/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.util.Base64;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class AcceptHashTest {
    @Test
    public void testHash() {
        byte[] key = TypeUtil.fromHexString((String)"00112233445566778899AABBCCDDEEFF");
        MatcherAssert.assertThat((String)"Key size", (Object)key.length, (Matcher)Matchers.is((Object)16));
        String clientKey = Base64.getEncoder().encodeToString(key);
        String serverHash = AcceptHash.hashKey((String)clientKey);
        MatcherAssert.assertThat((Object)serverHash, (Matcher)Matchers.is((Object)"mVL6JKtNRC4tluIaFAW2hhMffgE="));
    }

    @Test
    public void testRfcHashExample() {
        String clientKey = "dGhlIHNhbXBsZSBub25jZQ==";
        String serverAccept = AcceptHash.hashKey((String)clientKey);
        String expectedHash = "s3pPLMBiTxaQ9kYGzzhZRbK+xOo=";
        MatcherAssert.assertThat((Object)serverAccept, (Matcher)Matchers.is((Object)expectedHash));
    }
}

