/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class CloseInfoTest {
    @Test
    public void testAnonymousClose() {
        CloseInfo close = new CloseInfo();
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1005));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        CloseFrame frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame has payload", (Object)frame.hasPayload(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNoCode() {
        CloseInfo close = new CloseInfo(1005);
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1005));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        CloseFrame frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame has payload", (Object)frame.hasPayload(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNoClose() {
        CloseInfo close = new CloseInfo(1006);
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1006));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        CloseFrame frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame has payload", (Object)frame.hasPayload(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testFailedTlsHandshake() {
        CloseInfo close = new CloseInfo(1015);
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1015));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        CloseFrame frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame has payload", (Object)frame.hasPayload(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testNormal() {
        CloseInfo close = new CloseInfo(1000);
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        CloseFrame frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)2));
    }

    private ByteBuffer asByteBuffer(int statusCode, String reason) {
        int len = 2;
        byte[] utf = null;
        if (StringUtil.isNotBlank((String)reason)) {
            utf = StringUtil.getUtf8Bytes((String)reason);
            len += utf.length;
        }
        ByteBuffer buf = BufferUtil.allocate((int)len);
        BufferUtil.flipToFill((ByteBuffer)buf);
        buf.put((byte)(statusCode >>> 8 & 0xFF));
        buf.put((byte)(statusCode >>> 0 & 0xFF));
        if (utf != null) {
            buf.put(utf, 0, utf.length);
        }
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        return buf;
    }

    @Test
    public void testFromFrame() {
        ByteBuffer payload = this.asByteBuffer(1000, null);
        MatcherAssert.assertThat((String)"payload length", (Object)payload.remaining(), (Matcher)Matchers.is((Object)2));
        CloseFrame frame = new CloseFrame();
        frame.setPayload(payload);
        CloseInfo close = new CloseInfo((Frame)frame);
        MatcherAssert.assertThat((String)"close.code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((String)"close.reason", (Object)close.getReason(), (Matcher)Matchers.nullValue());
        frame = close.asFrame();
        MatcherAssert.assertThat((String)"close frame op code", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
        MatcherAssert.assertThat((String)"close frame payload length", (Object)frame.getPayloadLength(), (Matcher)Matchers.is((Object)2));
    }
}

