/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.eclipse.jetty.websocket.common.util.MaskedByteBuffer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class ClosePayloadParserTest {
    @Test
    public void testGameOver() {
        String expectedReason = "Game Over";
        byte[] utf = expectedReason.getBytes(StandardCharsets.UTF_8);
        ByteBuffer payload = ByteBuffer.allocate(utf.length + 2);
        payload.putChar('\u03e8');
        payload.put(utf, 0, utf.length);
        payload.flip();
        ByteBuffer buf = ByteBuffer.allocate(24);
        buf.put((byte)-120);
        buf.put((byte)(0x80 | payload.remaining()));
        MaskedByteBuffer.putMask(buf);
        MaskedByteBuffer.putPayload(buf, payload);
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)8, 1);
        CloseInfo close = new CloseInfo((Frame)capture.getFrames().poll());
        MatcherAssert.assertThat((String)"CloseFrame.statusCode", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1000));
        MatcherAssert.assertThat((String)"CloseFrame.data", (Object)close.getReason(), (Matcher)Matchers.is((Object)expectedReason));
    }
}

