/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeneratorParserRoundtripTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParserAndGenerator() throws Exception {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        Generator gen = new Generator(policy, this.bufferPool);
        Parser parser = new Parser(policy, this.bufferPool);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler((IncomingFrames)capture);
        String message = "0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF";
        ByteBuffer out = this.bufferPool.acquire(8192, false);
        try {
            BufferUtil.flipToFill((ByteBuffer)out);
            TextFrame frame = new TextFrame().setPayload(message);
            ByteBuffer header = gen.generateHeaderBytes((Frame)frame);
            ByteBuffer payload = frame.getPayload();
            out.put(header);
            out.put(payload);
            BufferUtil.flipToFlush((ByteBuffer)out, (int)0);
            parser.parse(out);
        }
        finally {
            this.bufferPool.release(out);
        }
        capture.assertHasFrame((byte)1, 1);
        TextFrame txt = (TextFrame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Text parsed", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)message));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParserAndGeneratorMasked() throws Exception {
        Generator gen = new Generator(WebSocketPolicy.newClientPolicy(), this.bufferPool);
        Parser parser = new Parser(WebSocketPolicy.newServerPolicy(), this.bufferPool);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler((IncomingFrames)capture);
        String message = "0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF";
        ByteBuffer out = this.bufferPool.acquire(8192, false);
        BufferUtil.flipToFill((ByteBuffer)out);
        try {
            TextFrame frame = new TextFrame().setPayload(message);
            byte[] mask = new byte[4];
            Arrays.fill(mask, (byte)-1);
            frame.setMask(mask);
            ByteBuffer header = gen.generateHeaderBytes((Frame)frame);
            ByteBuffer payload = frame.getPayload();
            out.put(header);
            out.put(payload);
            BufferUtil.flipToFlush((ByteBuffer)out, (int)0);
            parser.parse(out);
        }
        finally {
            this.bufferPool.release(out);
        }
        capture.assertHasFrame((byte)1, 1);
        TextFrame txt = (TextFrame)capture.getFrames().poll();
        Assertions.assertTrue((boolean)txt.isMasked(), (String)"Text.isMasked");
        MatcherAssert.assertThat((String)"Text parsed", (Object)txt.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)message));
    }
}

