/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class PingPayloadParserTest {
    @Test
    public void testBasicPingParsing() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        BufferUtil.clearToFill((ByteBuffer)buf);
        buf.put(new byte[]{-119, 5, 72, 101, 108, 108, 111});
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)9, 1);
        PingFrame ping = (PingFrame)capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)ping.getPayload());
        MatcherAssert.assertThat((String)"PingFrame.payload", (Object)actual, (Matcher)Matchers.is((Object)"Hello"));
    }
}

