/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.junit.jupiter.api.Test;

public class RFC6455ExamplesGeneratorTest {
    private static final int FUDGE = 32;

    @Test
    public void testFragmentedUnmaskedTextMessage() {
        WebSocketFrame text1 = new TextFrame().setPayload("Hel").setFin(false);
        ContinuationFrame text2 = new ContinuationFrame().setPayload("lo");
        ByteBuffer actual1 = UnitGenerator.generate((Frame)text1);
        ByteBuffer actual2 = UnitGenerator.generate((Frame)text2);
        ByteBuffer expected1 = ByteBuffer.allocate(5);
        expected1.put(new byte[]{1, 3, 72, 101, 108});
        ByteBuffer expected2 = ByteBuffer.allocate(4);
        expected2.put(new byte[]{-128, 2, 108, 111});
        expected1.flip();
        expected2.flip();
        ByteBufferAssert.assertEquals("t1 buffers are not equal", expected1, actual1);
        ByteBufferAssert.assertEquals("t2 buffers are not equal", expected2, actual2);
    }

    @Test
    public void testSingleMaskedPongRequest() {
        PongFrame pong = new PongFrame().setPayload("Hello");
        pong.setMask(new byte[]{55, -6, 33, 61});
        ByteBuffer actual = UnitGenerator.generate((Frame)pong);
        ByteBuffer expected = ByteBuffer.allocate(11);
        expected.put(new byte[]{-118, -123, 55, -6, 33, 61, 127, -97, 77, 81, 88});
        expected.flip();
        ByteBufferAssert.assertEquals("pong buffers are not equal", expected, actual);
    }

    @Test
    public void testSingleMaskedTextMessage() {
        TextFrame text = new TextFrame().setPayload("Hello");
        text.setMask(new byte[]{55, -6, 33, 61});
        ByteBuffer actual = UnitGenerator.generate((Frame)text);
        ByteBuffer expected = ByteBuffer.allocate(11);
        expected.put(new byte[]{-127, -123, 55, -6, 33, 61, 127, -97, 77, 81, 88});
        expected.flip();
        ByteBufferAssert.assertEquals("masked text buffers are not equal", expected, actual);
    }

    @Test
    public void testSingleUnmasked256ByteBinaryMessage() {
        int dataSize = 256;
        BinaryFrame binary = new BinaryFrame();
        byte[] payload = new byte[dataSize];
        Arrays.fill(payload, (byte)68);
        binary.setPayload(ByteBuffer.wrap(payload));
        ByteBuffer actual = UnitGenerator.generate((Frame)binary);
        ByteBuffer expected = ByteBuffer.allocate(dataSize + 32);
        expected.put(new byte[]{-126, 126});
        expected.putShort((short)256);
        for (int i = 0; i < dataSize; ++i) {
            expected.put((byte)68);
        }
        expected.flip();
        ByteBufferAssert.assertEquals("binary buffers are not equal", expected, actual);
    }

    @Test
    public void testSingleUnmasked64KBinaryMessage() {
        int dataSize = 65536;
        BinaryFrame binary = new BinaryFrame();
        byte[] payload = new byte[dataSize];
        Arrays.fill(payload, (byte)68);
        binary.setPayload(ByteBuffer.wrap(payload));
        ByteBuffer actual = UnitGenerator.generate((Frame)binary);
        ByteBuffer expected = ByteBuffer.allocate(dataSize + 10);
        expected.put(new byte[]{-126, 127});
        expected.putInt(0);
        expected.putInt(65536);
        for (int i = 0; i < dataSize; ++i) {
            expected.put((byte)68);
        }
        expected.flip();
        ByteBufferAssert.assertEquals("binary buffers are not equal", expected, actual);
    }

    @Test
    public void testSingleUnmaskedPingRequest() throws Exception {
        PingFrame ping = new PingFrame().setPayload("Hello");
        ByteBuffer actual = UnitGenerator.generate((Frame)ping);
        ByteBuffer expected = ByteBuffer.allocate(10);
        expected.put(new byte[]{-119, 5, 72, 101, 108, 108, 111});
        expected.flip();
        ByteBufferAssert.assertEquals("Ping buffers", expected, actual);
    }

    @Test
    public void testSingleUnmaskedTextMessage() {
        TextFrame text = new TextFrame().setPayload("Hello");
        ByteBuffer actual = UnitGenerator.generate((Frame)text);
        ByteBuffer expected = ByteBuffer.allocate(10);
        expected.put(new byte[]{-127, 5, 72, 101, 108, 108, 111});
        expected.flip();
        ByteBufferAssert.assertEquals("t1 buffers are not equal", expected, actual);
    }
}

