/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class RFC6455ExamplesParserTest {
    @Test
    public void testFragmentedUnmaskedTextMessage() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        ByteBuffer buf = ByteBuffer.allocate(16);
        BufferUtil.clearToFill((ByteBuffer)buf);
        buf.put(new byte[]{1, 3, 72, 101, 108});
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        parser.parse(buf);
        BufferUtil.flipToFill((ByteBuffer)buf);
        buf.put(new byte[]{-128, 2, 108, 111});
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        capture.assertHasFrame((byte)0, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)txt.getPayload());
        MatcherAssert.assertThat((String)"TextFrame[0].data", (Object)actual, (Matcher)Matchers.is((Object)"Hel"));
        txt = capture.getFrames().poll();
        actual = BufferUtil.toUTF8String((ByteBuffer)txt.getPayload());
        MatcherAssert.assertThat((String)"TextFrame[1].data", (Object)actual, (Matcher)Matchers.is((Object)"lo"));
    }

    @Test
    public void testSingleMaskedPongRequest() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.put(new byte[]{-118, -123, 55, -6, 33, 61, 127, -97, 77, 81, 88});
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)10, 1);
        WebSocketFrame pong = capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)pong.getPayload());
        MatcherAssert.assertThat((String)"PongFrame.payload", (Object)actual, (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    public void testSingleMaskedTextMessage() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.put(new byte[]{-127, -123, 55, -6, 33, 61, 127, -97, 77, 81, 88});
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)txt.getPayload());
        MatcherAssert.assertThat((String)"TextFrame.payload", (Object)actual, (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    public void testSingleUnmasked256ByteBinaryMessage() {
        int dataSize = 256;
        ByteBuffer buf = ByteBuffer.allocate(dataSize + 10);
        buf.put(new byte[]{-126, 126});
        buf.putShort((short)256);
        for (int i = 0; i < dataSize; ++i) {
            buf.put((byte)68);
        }
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)2, 1);
        Frame bin = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)bin.getPayloadLength(), (Matcher)Matchers.is((Object)dataSize));
        ByteBuffer data = bin.getPayload();
        MatcherAssert.assertThat((String)"BinaryFrame.payload.length", (Object)data.remaining(), (Matcher)Matchers.is((Object)dataSize));
        for (int i = 0; i < dataSize; ++i) {
            MatcherAssert.assertThat((String)("BinaryFrame.payload[" + i + "]"), (Object)data.get(i), (Matcher)Matchers.is((Object)68));
        }
    }

    @Test
    public void testSingleUnmasked64KByteBinaryMessage() {
        int dataSize = 65536;
        ByteBuffer buf = ByteBuffer.allocate(dataSize + 10);
        buf.put(new byte[]{-126, 127});
        buf.putLong(dataSize);
        for (int i = 0; i < dataSize; ++i) {
            buf.put((byte)119);
        }
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)2, 1);
        Frame bin = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"BinaryFrame.payloadLength", (Object)bin.getPayloadLength(), (Matcher)Matchers.is((Object)dataSize));
        ByteBuffer data = bin.getPayload();
        MatcherAssert.assertThat((String)"BinaryFrame.payload.length", (Object)data.remaining(), (Matcher)Matchers.is((Object)dataSize));
        for (int i = 0; i < dataSize; ++i) {
            MatcherAssert.assertThat((String)("BinaryFrame.payload[" + i + "]"), (Object)data.get(i), (Matcher)Matchers.is((Object)119));
        }
    }

    @Test
    public void testSingleUnmaskedPingRequest() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.put(new byte[]{-119, 5, 72, 101, 108, 108, 111});
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame ping = capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)ping.getPayload());
        MatcherAssert.assertThat((String)"PingFrame.payload", (Object)actual, (Matcher)Matchers.is((Object)"Hello"));
    }

    @Test
    public void testSingleUnmaskedTextMessage() {
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.put(new byte[]{-127, 5, 72, 101, 108, 108, 111});
        buf.flip();
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);
        UnitParser parser = new UnitParser(policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(buf);
        capture.assertHasFrame((byte)1, 1);
        WebSocketFrame txt = capture.getFrames().poll();
        String actual = BufferUtil.toUTF8String((ByteBuffer)txt.getPayload());
        MatcherAssert.assertThat((String)"TextFrame.payload", (Object)actual, (Matcher)Matchers.is((Object)"Hello"));
    }
}

