/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WebSocketFrameTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    private Generator strictGenerator;
    private Generator laxGenerator;

    private ByteBuffer generateWholeFrame(Generator generator, Frame frame) {
        ByteBuffer buf = ByteBuffer.allocate(frame.getPayloadLength() + 28);
        generator.generateWholeFrame(frame, buf);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        return buf;
    }

    @BeforeEach
    public void initGenerator() {
        WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
        this.strictGenerator = new Generator(policy, this.bufferPool);
        this.laxGenerator = new Generator(policy, this.bufferPool, false);
    }

    private void assertFrameHex(String message, String expectedHex, ByteBuffer actual) {
        String actualHex = Hex.asHex(actual);
        MatcherAssert.assertThat((String)("Generated Frame:" + message), (Object)actualHex, (Matcher)Matchers.is((Object)expectedHex));
    }

    @Test
    public void testLaxInvalidClose() {
        WebSocketFrame frame = new CloseFrame().setFin(false);
        ByteBuffer actual = this.generateWholeFrame(this.laxGenerator, (Frame)frame);
        String expected = "0800";
        this.assertFrameHex("Lax Invalid Close Frame", expected, actual);
    }

    @Test
    public void testLaxInvalidPing() {
        WebSocketFrame frame = new PingFrame().setFin(false);
        ByteBuffer actual = this.generateWholeFrame(this.laxGenerator, (Frame)frame);
        String expected = "0900";
        this.assertFrameHex("Lax Invalid Ping Frame", expected, actual);
    }

    @Test
    public void testStrictValidClose() {
        CloseInfo close = new CloseInfo(1000);
        ByteBuffer actual = this.generateWholeFrame(this.strictGenerator, (Frame)close.asFrame());
        String expected = "880203E8";
        this.assertFrameHex("Strict Valid Close Frame", expected, actual);
    }

    @Test
    public void testStrictValidPing() {
        PingFrame frame = new PingFrame();
        ByteBuffer actual = this.generateWholeFrame(this.strictGenerator, (Frame)frame);
        String expected = "8900";
        this.assertFrameHex("Strict Valid Ping Frame", expected, actual);
    }

    @Test
    public void testRsv1() {
        TextFrame frame = new TextFrame();
        frame.setPayload("Hi");
        frame.setRsv1(true);
        this.laxGenerator.setRsv1InUse(true);
        ByteBuffer actual = this.generateWholeFrame(this.laxGenerator, (Frame)frame);
        String expected = "C1024869";
        this.assertFrameHex("Lax Text Frame with RSV1", expected, actual);
    }

    @Test
    public void testRsv2() {
        TextFrame frame = new TextFrame();
        frame.setPayload("Hi");
        frame.setRsv2(true);
        this.laxGenerator.setRsv2InUse(true);
        ByteBuffer actual = this.generateWholeFrame(this.laxGenerator, (Frame)frame);
        String expected = "A1024869";
        this.assertFrameHex("Lax Text Frame with RSV2", expected, actual);
    }

    @Test
    public void testRsv3() {
        TextFrame frame = new TextFrame();
        frame.setPayload("Hi");
        frame.setRsv3(true);
        this.laxGenerator.setRsv3InUse(true);
        ByteBuffer actual = this.generateWholeFrame(this.laxGenerator, (Frame)frame);
        String expected = "91024869";
        this.assertFrameHex("Lax Text Frame with RSV3", expected, actual);
    }
}

