/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.SaneFrameOrderingAssertion;
import org.eclipse.jetty.websocket.common.WebSocketRemoteEndpoint;
import org.eclipse.jetty.websocket.common.io.LocalWebSocketConnection;
import org.eclipse.jetty.websocket.common.test.OutgoingFramesCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class WebSocketRemoteEndpointTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    @Test
    public void testTextBinaryText(TestInfo testinfo) throws IOException {
        String id = testinfo.getDisplayName();
        LocalWebSocketConnection conn = new LocalWebSocketConnection(id, this.bufferPool);
        OutgoingFramesCapture outgoing = new OutgoingFramesCapture();
        WebSocketRemoteEndpoint remote = new WebSocketRemoteEndpoint((LogicalConnection)conn, (OutgoingFrames)outgoing);
        conn.opening();
        conn.opened();
        remote.sendPartialString("Hello ", false);
        IllegalStateException e = (IllegalStateException)Assertions.assertThrows(IllegalStateException.class, () -> {
            ByteBuffer bytes = ByteBuffer.wrap(new byte[]{0, 1, 2});
            remote.sendPartialBytes(bytes, false);
        });
        MatcherAssert.assertThat((String)"Exception", (Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot send"));
        remote.sendPartialString("World!", true);
    }

    @Test
    public void testTextPingText(TestInfo testinfo) throws IOException {
        String id = testinfo.getDisplayName();
        LocalWebSocketConnection conn = new LocalWebSocketConnection(id, this.bufferPool);
        OutgoingFramesCapture outgoing = new OutgoingFramesCapture();
        WebSocketRemoteEndpoint remote = new WebSocketRemoteEndpoint((LogicalConnection)conn, (OutgoingFrames)outgoing);
        conn.opening();
        conn.opened();
        remote.sendPartialString("Hello ", false);
        remote.sendPing(ByteBuffer.wrap(new byte[]{0}));
        remote.sendPartialString("World!", true);
    }

    @Test
    public void testLargeSmallText(TestInfo testInfo) throws ExecutionException, InterruptedException {
        LocalWebSocketConnection conn = new LocalWebSocketConnection(testInfo.getDisplayName(), this.bufferPool);
        SaneFrameOrderingAssertion orderingAssert = new SaneFrameOrderingAssertion();
        WebSocketRemoteEndpoint remote = new WebSocketRemoteEndpoint((LogicalConnection)conn, (OutgoingFrames)orderingAssert);
        conn.opening();
        conn.opened();
        int largeMessageSize = 60000;
        byte[] buf = new byte[largeMessageSize];
        Arrays.fill(buf, (byte)120);
        String largeMessage = new String(buf, StandardCharsets.UTF_8);
        int messageCount = 10000;
        for (int i = 0; i < messageCount; ++i) {
            Future fut = i % 2 == 0 ? remote.sendStringByFuture(largeMessage) : remote.sendStringByFuture("Short Message: " + i);
            fut.get();
        }
    }
}

