/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestABCase2 {
    private WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);

    @Test
    public void testGenerate125OctetPingCase24() {
        byte[] bytes = new byte[125];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Integer.valueOf(Integer.toOctalString(i)).byteValue();
        }
        PingFrame pingFrame = new PingFrame().setPayload(bytes);
        ByteBuffer actual = UnitGenerator.generate((Frame)pingFrame);
        ByteBuffer expected = ByteBuffer.allocate(bytes.length + 32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | bytes.length & 0x7F);
        expected.put(b);
        expected.put(bytes);
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testGenerateBinaryPingCase23() {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        PingFrame pingFrame = new PingFrame().setPayload(bytes);
        ByteBuffer actual = UnitGenerator.generate((Frame)pingFrame);
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | bytes.length & 0x7F);
        expected.put(b);
        expected.put(bytes);
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testGenerateEmptyPingCase21() {
        PingFrame pingFrame = new PingFrame();
        ByteBuffer actual = UnitGenerator.generate((Frame)pingFrame);
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-119, 0});
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerateHelloPingCase22() {
        String message = "Hello, world!";
        byte[] messageBytes = StringUtil.getUtf8Bytes((String)message);
        PingFrame pingFrame = new PingFrame().setPayload(messageBytes);
        ByteBuffer actual = UnitGenerator.generate((Frame)pingFrame);
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | messageBytes.length & 0x7F);
        expected.put(b);
        expected.put(messageBytes);
        expected.flip();
        ByteBufferAssert.assertEquals(expected, actual, "buffers do not match");
    }

    @Test
    public void testGenerateOversizedBinaryPingCase25A() {
        byte[] bytes = new byte[126];
        Arrays.fill(bytes, (byte)0);
        PingFrame pingFrame = new PingFrame();
        Assertions.assertThrows(WebSocketException.class, () -> pingFrame.setPayload(ByteBuffer.wrap(bytes)));
    }

    @Test
    public void testGenerateOversizedBinaryPingCase25B() {
        byte[] bytes = new byte[126];
        Arrays.fill(bytes, (byte)0);
        PingFrame pingFrame = new PingFrame();
        Assertions.assertThrows(WebSocketException.class, () -> pingFrame.setPayload(ByteBuffer.wrap(bytes)));
    }

    @Test
    public void testParse125OctetPingCase24() {
        byte[] bytes = new byte[125];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = Integer.valueOf(Integer.toOctalString(i)).byteValue();
        }
        ByteBuffer expected = ByteBuffer.allocate(bytes.length + 32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | bytes.length & 0x7F);
        expected.put(b);
        expected.put(bytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)9, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"PingFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)bytes.length));
        Assertions.assertEquals((int)bytes.length, (int)pActual.getPayloadLength(), (String)"PingFrame.payload");
    }

    @Test
    public void testParseBinaryPingCase23() {
        byte[] bytes = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | bytes.length & 0x7F);
        expected.put(b);
        expected.put(bytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)9, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"PingFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)bytes.length));
        Assertions.assertEquals((int)bytes.length, (int)pActual.getPayloadLength(), (String)"PingFrame.payload");
    }

    @Test
    public void testParseEmptyPingCase21() {
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-119, 0});
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)9, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"PingFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)0));
        Assertions.assertEquals((int)0, (int)pActual.getPayloadLength(), (String)"PingFrame.payload");
    }

    @Test
    public void testParseHelloPingCase22() {
        String message = "Hello, world!";
        byte[] messageBytes = message.getBytes();
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-119});
        byte b = 0;
        b = (byte)(b | messageBytes.length & 0x7F);
        expected.put(b);
        expected.put(messageBytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)9, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"PingFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)message.length()));
        Assertions.assertEquals((int)message.length(), (int)pActual.getPayloadLength(), (String)"PingFrame.payload");
    }

    @Test
    public void testParseOversizedBinaryPingCase25() {
        byte[] bytes = new byte[126];
        Arrays.fill(bytes, (byte)0);
        ByteBuffer expected = ByteBuffer.allocate(bytes.length + 28);
        byte b = 0;
        b = (byte)(b | 0x80);
        b = (byte)(b | 9);
        expected.put(b);
        b = 0;
        b = (byte)(b | 0);
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.putChar((char)bytes.length);
        expected.put(bytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        ProtocolException x = (ProtocolException)Assertions.assertThrows(ProtocolException.class, () -> parser.parseQuietly(expected));
        MatcherAssert.assertThat((Object)x.getMessage(), (Matcher)Matchers.containsString((String)"Invalid control frame payload length"));
    }
}

