/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.ab;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.ProtocolException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestABCase73 {
    private WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.CLIENT);

    @Test
    public void testCase731GenerateEmptyClose() {
        CloseInfo close = new CloseInfo();
        ByteBuffer actual = UnitGenerator.generate((Frame)close.asFrame());
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-120, 0});
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testCase731ParseEmptyClose() {
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-120, 0});
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)8, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"CloseFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)0));
    }

    @Test
    public void testCase732Generate1BytePayloadClose() {
        CloseFrame closeFrame = new CloseFrame();
        closeFrame.setPayload(Hex.asByteBuffer("00"));
        Assertions.assertThrows(ProtocolException.class, () -> UnitGenerator.generate((Frame)closeFrame));
    }

    @Test
    public void testCase732Parse1BytePayloadClose() {
        ByteBuffer expected = Hex.asByteBuffer("880100");
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        Assertions.assertThrows(ProtocolException.class, () -> parser.parseQuietly(expected));
    }

    @Test
    public void testCase733GenerateCloseWithStatus() {
        CloseInfo close = new CloseInfo(1000);
        ByteBuffer actual = UnitGenerator.generate((Frame)close.asFrame());
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-120, 2, 3, -24});
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testCase733ParseCloseWithStatus() {
        ByteBuffer expected = ByteBuffer.allocate(5);
        expected.put(new byte[]{-120, 2, 3, -24});
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)8, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"CloseFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)2));
    }

    @Test
    public void testCase734GenerateCloseWithStatusReason() {
        String message = "bad cough";
        byte[] messageBytes = message.getBytes();
        CloseInfo close = new CloseInfo(1000, message);
        ByteBuffer actual = UnitGenerator.generate((Frame)close.asFrame());
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-120});
        byte b = 0;
        b = (byte)(b | message.length() + 2 & 0x7F);
        expected.put(b);
        expected.putShort((short)1000);
        expected.put(messageBytes);
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testCase734ParseCloseWithStatusReason() {
        String message = "bad cough";
        byte[] messageBytes = message.getBytes();
        ByteBuffer expected = ByteBuffer.allocate(32);
        expected.put(new byte[]{-120});
        byte b = 0;
        b = (byte)(b | messageBytes.length + 2 & 0x7F);
        expected.put(b);
        expected.putShort((short)1000);
        expected.put(messageBytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)8, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"CloseFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)(messageBytes.length + 2)));
    }

    @Test
    public void testCase735GenerateCloseWithStatusMaxReason() {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < 123; ++i) {
            message.append("*");
        }
        CloseInfo close = new CloseInfo(1000, message.toString());
        ByteBuffer actual = UnitGenerator.generate((Frame)close.asFrame());
        ByteBuffer expected = ByteBuffer.allocate(132);
        byte[] messageBytes = message.toString().getBytes(StandardCharsets.UTF_8);
        expected.put(new byte[]{-120});
        byte b = 0;
        b = (byte)(b | messageBytes.length + 2 & 0x7F);
        expected.put(b);
        expected.putShort((short)1000);
        expected.put(messageBytes);
        expected.flip();
        ByteBufferAssert.assertEquals("buffers do not match", expected, actual);
    }

    @Test
    public void testCase735ParseCloseWithStatusMaxReason() {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < 123; ++i) {
            message.append("*");
        }
        byte[] messageBytes = message.toString().getBytes(StandardCharsets.UTF_8);
        ByteBuffer expected = ByteBuffer.allocate(132);
        expected.put(new byte[]{-120});
        byte b = 0;
        b = (byte)(b | messageBytes.length + 2 & 0x7F);
        expected.put(b);
        expected.putShort((short)1000);
        expected.put(messageBytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        parser.parse(expected);
        capture.assertHasFrame((byte)8, 1);
        Frame pActual = (Frame)capture.getFrames().poll();
        MatcherAssert.assertThat((String)"CloseFrame.payloadLength", (Object)pActual.getPayloadLength(), (Matcher)Matchers.is((Object)125));
    }

    @Test
    public void testCase736GenerateCloseWithInvalidStatusReason() {
        StringBuilder message = new StringBuilder();
        for (int i = 0; i < 124; ++i) {
            message.append("*");
        }
        byte[] messageBytes = message.toString().getBytes();
        CloseFrame closeFrame = new CloseFrame();
        ByteBuffer bb = ByteBuffer.allocate(126);
        bb.putChar('\u03e8');
        bb.put(messageBytes);
        BufferUtil.flipToFlush((ByteBuffer)bb, (int)0);
        Assertions.assertThrows(ProtocolException.class, () -> {
            closeFrame.setPayload(bb);
            UnitGenerator.generate((Frame)closeFrame);
        });
    }

    @Test
    public void testCase736ParseCloseWithInvalidStatusReason() {
        byte[] messageBytes = new byte[124];
        Arrays.fill(messageBytes, (byte)42);
        ByteBuffer expected = ByteBuffer.allocate(256);
        byte b = 0;
        b = (byte)(b | 0x80);
        b = (byte)(b | 8);
        expected.put(b);
        b = 0;
        b = (byte)(b | 0);
        b = (byte)(b | 0x7E);
        expected.put(b);
        expected.putChar((char)(messageBytes.length + 2));
        expected.putShort((short)1000);
        expected.put(messageBytes);
        expected.flip();
        UnitParser parser = new UnitParser(this.policy);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        parser.setIncomingFramesHandler(capture);
        Assertions.assertThrows(ProtocolException.class, () -> parser.parseQuietly(expected));
    }
}

