/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import examples.AdapterConnectCloseSocket;
import examples.ListenerBasicSocket;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.annotations.NotASocket;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.events.JettyListenerEventDriver;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class EventDriverFactoryTest {
    @Test
    public void testAdapterConnectCloseSocket() {
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)new SimpleContainerScope(WebSocketPolicy.newClientPolicy()));
        AdapterConnectCloseSocket socket = new AdapterConnectCloseSocket();
        EventDriver driver = factory.wrap((Object)socket);
        String classId = AdapterConnectCloseSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventDriver for " + classId), (Object)driver, (Matcher)Matchers.instanceOf(JettyListenerEventDriver.class));
    }

    @Test
    public void testBadNotASocket() {
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)new SimpleContainerScope(WebSocketPolicy.newClientPolicy()));
        try {
            NotASocket bad = new NotASocket();
            factory.wrap((Object)bad);
        }
        catch (InvalidWebSocketException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)WebSocketListener.class.getSimpleName()), (Matcher)Matchers.containsString((String)WebSocket.class.getSimpleName())));
        }
    }

    @Test
    public void testListenerBasicSocket() {
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)new SimpleContainerScope(WebSocketPolicy.newClientPolicy()));
        ListenerBasicSocket socket = new ListenerBasicSocket();
        EventDriver driver = factory.wrap((Object)socket);
        String classId = ListenerBasicSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventDriver for " + classId), (Object)driver, (Matcher)Matchers.instanceOf(JettyListenerEventDriver.class));
    }
}

