/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.events;

import examples.AnnotatedBinaryArraySocket;
import examples.AnnotatedBinaryStreamSocket;
import examples.AnnotatedTextSocket;
import examples.AnnotatedTextStreamSocket;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.common.annotations.BadBinarySignatureSocket;
import org.eclipse.jetty.websocket.common.annotations.BadDuplicateBinarySocket;
import org.eclipse.jetty.websocket.common.annotations.BadDuplicateFrameSocket;
import org.eclipse.jetty.websocket.common.annotations.BadTextSignatureSocket;
import org.eclipse.jetty.websocket.common.annotations.FrameSocket;
import org.eclipse.jetty.websocket.common.annotations.MyEchoBinarySocket;
import org.eclipse.jetty.websocket.common.annotations.MyEchoSocket;
import org.eclipse.jetty.websocket.common.annotations.MyStatelessEchoSocket;
import org.eclipse.jetty.websocket.common.annotations.NoopSocket;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedMetadata;
import org.eclipse.jetty.websocket.common.events.JettyAnnotatedScanner;
import org.eclipse.jetty.websocket.common.events.annotated.CallableMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class JettyAnnotatedScannerTest {
    private void assertHasEventMethod(String message, CallableMethod actual) {
        MatcherAssert.assertThat((String)(message + " CallableMethod"), (Object)actual, (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)(message + " CallableMethod.pojo"), (Object)actual.getPojo(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((String)(message + " CallableMethod.method"), (Object)actual.getMethod(), (Matcher)Matchers.notNullValue());
    }

    private void assertNoEventMethod(String message, CallableMethod actual) {
        MatcherAssert.assertThat((String)(message + " CallableMethod"), (Object)actual, (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAnnotatedBadDuplicateBinarySocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        InvalidWebSocketException e = (InvalidWebSocketException)Assertions.assertThrows(InvalidWebSocketException.class, () -> impl.scan(BadDuplicateBinarySocket.class));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Duplicate @OnWebSocketMessage declaration"));
    }

    @Test
    public void testAnnotatedBadDuplicateFrameSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        InvalidWebSocketException e = (InvalidWebSocketException)Assertions.assertThrows(InvalidWebSocketException.class, () -> impl.scan(BadDuplicateFrameSocket.class));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Duplicate @OnWebSocketFrame"));
    }

    @Test
    public void testAnnotatedBadSignatureNonVoidReturn() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        InvalidWebSocketException e = (InvalidWebSocketException)Assertions.assertThrows(InvalidWebSocketException.class, () -> impl.scan(BadBinarySignatureSocket.class));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"must be void"));
    }

    @Test
    public void testAnnotatedBadSignatureStatic() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        InvalidWebSocketException e = (InvalidWebSocketException)Assertions.assertThrows(InvalidWebSocketException.class, () -> impl.scan(BadTextSignatureSocket.class));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"may not be static"));
    }

    @Test
    public void testAnnotatedBinaryArraySocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(AnnotatedBinaryArraySocket.class);
        String classId = AnnotatedBinaryArraySocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertHasEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertNoEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
        Assertions.assertFalse((boolean)metadata.onBinary.isSessionAware(), (String)(classId + ".onBinary.isSessionAware"));
        Assertions.assertFalse((boolean)metadata.onBinary.isStreaming(), (String)(classId + ".onBinary.isStreaming"));
    }

    @Test
    public void testAnnotatedBinaryStreamSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(AnnotatedBinaryStreamSocket.class);
        String classId = AnnotatedBinaryStreamSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertHasEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertNoEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
        Assertions.assertFalse((boolean)metadata.onBinary.isSessionAware(), (String)(classId + ".onBinary.isSessionAware"));
        Assertions.assertTrue((boolean)metadata.onBinary.isStreaming(), (String)(classId + ".onBinary.isStreaming"));
    }

    @Test
    public void testAnnotatedMyEchoBinarySocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(MyEchoBinarySocket.class);
        String classId = MyEchoBinarySocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertHasEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertHasEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
    }

    @Test
    public void testAnnotatedMyEchoSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(MyEchoSocket.class);
        String classId = MyEchoSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertHasEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
    }

    @Test
    public void testAnnotatedMyStatelessEchoSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(MyStatelessEchoSocket.class);
        String classId = MyStatelessEchoSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertNoEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertNoEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertHasEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
        Assertions.assertTrue((boolean)metadata.onText.isSessionAware(), (String)(classId + ".onText.isSessionAware"));
        Assertions.assertFalse((boolean)metadata.onText.isStreaming(), (String)(classId + ".onText.isStreaming"));
    }

    @Test
    public void testAnnotatedNoop() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(NoopSocket.class);
        String classId = NoopSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("Methods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertNoEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertNoEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertNoEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
    }

    @Test
    public void testAnnotatedOnFrame() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(FrameSocket.class);
        String classId = FrameSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertNoEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertNoEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertNoEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertHasEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
    }

    @Test
    public void testAnnotatedTextSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(AnnotatedTextSocket.class);
        String classId = AnnotatedTextSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertHasEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertHasEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
        Assertions.assertFalse((boolean)metadata.onText.isSessionAware(), (String)(classId + ".onText.isSessionAware"));
        Assertions.assertFalse((boolean)metadata.onText.isStreaming(), (String)(classId + ".onText.isStreaming"));
    }

    @Test
    public void testAnnotatedTextStreamSocket() {
        JettyAnnotatedScanner impl = new JettyAnnotatedScanner();
        JettyAnnotatedMetadata metadata = impl.scan(AnnotatedTextStreamSocket.class);
        String classId = AnnotatedTextStreamSocket.class.getSimpleName();
        MatcherAssert.assertThat((String)("EventMethods for " + classId), (Object)metadata, (Matcher)Matchers.notNullValue());
        this.assertNoEventMethod(classId + ".onBinary", (CallableMethod)metadata.onBinary);
        this.assertHasEventMethod(classId + ".onClose", (CallableMethod)metadata.onClose);
        this.assertHasEventMethod(classId + ".onConnect", metadata.onConnect);
        this.assertNoEventMethod(classId + ".onException", (CallableMethod)metadata.onError);
        this.assertHasEventMethod(classId + ".onText", (CallableMethod)metadata.onText);
        this.assertNoEventMethod(classId + ".onFrame", (CallableMethod)metadata.onFrame);
        Assertions.assertFalse((boolean)metadata.onText.isSessionAware(), (String)(classId + ".onText.isSessionAware"));
        Assertions.assertTrue((boolean)metadata.onText.isStreaming(), (String)(classId + ".onText.isStreaming"));
    }
}

