/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.SaneFrameOrderingAssertion;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.fragment.FragmentExtension;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.OutgoingFramesCapture;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class FragmentExtensionTest {
    private static final Logger LOG = Log.getLogger(FragmentExtensionTest.class);
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    @Test
    public void testIncomingFrames() {
        IncomingFramesCapture capture = new IncomingFramesCapture();
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newClientPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment;maxLength=4");
        ext.setConfig(config);
        ext.setNextIncomingFrames((IncomingFrames)capture);
        ArrayList<String> quote = new ArrayList<String>();
        quote.add("No amount of experimentation can ever prove me right;");
        quote.add("a single experiment can prove me wrong.");
        quote.add("-- Albert Einstein");
        for (String q : quote) {
            TextFrame frame = new TextFrame().setPayload(q);
            ext.incomingFrame((Frame)frame);
        }
        int len = quote.size();
        capture.assertFrameCount(len);
        capture.assertHasFrame((byte)1, len);
        int i = 0;
        for (WebSocketFrame actual : capture.getFrames()) {
            String prefix = "Frame[" + i + "]";
            MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
            ByteBuffer expected = BufferUtil.toBuffer((String)((String)quote.get(i)), (Charset)StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
            ByteBufferAssert.assertEquals(prefix + ".payload", expected, actual.getPayload().slice());
            ++i;
        }
    }

    @Test
    public void testIncomingPing() {
        IncomingFramesCapture capture = new IncomingFramesCapture();
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment;maxLength=4");
        ext.setConfig(config);
        ext.setNextIncomingFrames((IncomingFrames)capture);
        String payload = "Are you there?";
        PingFrame ping = new PingFrame().setPayload(payload);
        ext.incomingFrame((Frame)ping);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame actual = capture.getFrames().poll();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)payload, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals("Frame.payload", expected, actual.getPayload().slice());
    }

    @Test
    public void testOutgoingFramesByMaxLength() throws IOException, InterruptedException {
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment;maxLength=20");
        ext.setConfig(config);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        ArrayList<String> quote = new ArrayList<String>();
        quote.add("No amount of experimentation can ever prove me right;");
        quote.add("a single experiment can prove me wrong.");
        quote.add("-- Albert Einstein");
        for (String section : quote) {
            TextFrame frame = new TextFrame().setPayload(section);
            ext.outgoingFrame((Frame)frame, null, BatchMode.OFF);
        }
        ArrayList<WebSocketFrame> expectedFrames = new ArrayList<WebSocketFrame>();
        expectedFrames.add(new TextFrame().setPayload("No amount of experim").setFin(false));
        expectedFrames.add(new ContinuationFrame().setPayload("entation can ever pr").setFin(false));
        expectedFrames.add(new ContinuationFrame().setPayload("ove me right;").setFin(true));
        expectedFrames.add(new TextFrame().setPayload("a single experiment ").setFin(false));
        expectedFrames.add(new ContinuationFrame().setPayload("can prove me wrong.").setFin(true));
        expectedFrames.add(new TextFrame().setPayload("-- Albert Einstein").setFin(true));
        int len = expectedFrames.size();
        capture.assertFrameCount(len);
        LinkedBlockingDeque<WebSocketFrame> frames = capture.getFrames();
        for (int i = 0; i < len; ++i) {
            String prefix = "Frame[" + i + "]";
            WebSocketFrame actualFrame = frames.poll(1L, TimeUnit.SECONDS);
            WebSocketFrame expectedFrame = (WebSocketFrame)expectedFrames.get(i);
            MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actualFrame.getOpCode(), (Matcher)Matchers.is((Object)expectedFrame.getOpCode()));
            MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actualFrame.isFin(), (Matcher)Matchers.is((Object)expectedFrame.isFin()));
            MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actualFrame.isRsv1(), (Matcher)Matchers.is((Object)expectedFrame.isRsv1()));
            MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actualFrame.isRsv2(), (Matcher)Matchers.is((Object)expectedFrame.isRsv2()));
            MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actualFrame.isRsv3(), (Matcher)Matchers.is((Object)expectedFrame.isRsv3()));
            ByteBuffer expectedData = expectedFrame.getPayload().slice();
            ByteBuffer actualData = actualFrame.getPayload().slice();
            MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actualData.remaining(), (Matcher)Matchers.is((Object)expectedData.remaining()));
            ByteBufferAssert.assertEquals(prefix + ".payload", expectedData, actualData);
        }
    }

    @Test
    public void testOutgoingFramesDefaultConfig() throws Exception {
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment");
        ext.setConfig(config);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        ArrayList<String> quote = new ArrayList<String>();
        quote.add("No amount of experimentation can ever prove me right;");
        quote.add("a single experiment can prove me wrong.");
        quote.add("-- Albert Einstein");
        for (String section : quote) {
            TextFrame frame = new TextFrame().setPayload(section);
            ext.outgoingFrame((Frame)frame, null, BatchMode.OFF);
        }
        ArrayList<TextFrame> expectedFrames = new ArrayList<TextFrame>();
        expectedFrames.add(new TextFrame().setPayload("No amount of experimentation can ever prove me right;"));
        expectedFrames.add(new TextFrame().setPayload("a single experiment can prove me wrong."));
        expectedFrames.add(new TextFrame().setPayload("-- Albert Einstein"));
        int len = expectedFrames.size();
        capture.assertFrameCount(len);
        LinkedBlockingDeque<WebSocketFrame> frames = capture.getFrames();
        for (int i = 0; i < len; ++i) {
            String prefix = "Frame[" + i + "]";
            WebSocketFrame actualFrame = frames.poll(1L, TimeUnit.SECONDS);
            WebSocketFrame expectedFrame = (WebSocketFrame)expectedFrames.get(i);
            MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actualFrame.getOpCode(), (Matcher)Matchers.is((Object)expectedFrame.getOpCode()));
            MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actualFrame.isFin(), (Matcher)Matchers.is((Object)expectedFrame.isFin()));
            MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actualFrame.isRsv1(), (Matcher)Matchers.is((Object)expectedFrame.isRsv1()));
            MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actualFrame.isRsv2(), (Matcher)Matchers.is((Object)expectedFrame.isRsv2()));
            MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actualFrame.isRsv3(), (Matcher)Matchers.is((Object)expectedFrame.isRsv3()));
            ByteBuffer expectedData = expectedFrame.getPayload().slice();
            ByteBuffer actualData = actualFrame.getPayload().slice();
            MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actualData.remaining(), (Matcher)Matchers.is((Object)expectedData.remaining()));
            ByteBufferAssert.assertEquals(prefix + ".payload", expectedData, actualData);
        }
    }

    @Test
    public void testOutgoingPing() throws IOException {
        OutgoingFramesCapture capture = new OutgoingFramesCapture();
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment;maxLength=4");
        ext.setConfig(config);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        String payload = "Are you there?";
        PingFrame ping = new PingFrame().setPayload(payload);
        ext.outgoingFrame((Frame)ping, null, BatchMode.OFF);
        capture.assertFrameCount(1);
        capture.assertHasFrame((byte)9, 1);
        WebSocketFrame actual = capture.getFrames().getFirst();
        MatcherAssert.assertThat((String)"Frame.opcode", (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)9));
        MatcherAssert.assertThat((String)"Frame.fin", (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Frame.rsv1", (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv2", (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Frame.rsv3", (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
        ByteBuffer expected = BufferUtil.toBuffer((String)payload, (Charset)StandardCharsets.UTF_8);
        MatcherAssert.assertThat((String)"Frame.payloadLength", (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
        ByteBufferAssert.assertEquals("Frame.payload", expected, actual.getPayload().slice());
    }

    @Test
    public void testLargeSmallTextAlternating() throws Exception {
        int largeMessageSize = 60000;
        byte[] buf = new byte[60000];
        Arrays.fill(buf, (byte)120);
        String largeMessage = new String(buf, StandardCharsets.UTF_8);
        int fragmentCount = 10;
        int fragmentLength = 6000;
        int messageCount = 10000;
        FragmentExtension ext = new FragmentExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setPolicy(WebSocketPolicy.newServerPolicy());
        ExtensionConfig config = ExtensionConfig.parse((String)"fragment;maxLength=6000");
        ext.setConfig(config);
        SaneFrameOrderingAssertion saneFrameOrderingAssertion = new SaneFrameOrderingAssertion();
        ext.setNextOutgoingFrames((OutgoingFrames)saneFrameOrderingAssertion);
        CompletableFuture enqueuedFrameCountFut = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            int frameCount = 0;
            BatchMode batchMode = BatchMode.OFF;
            try {
                for (int i = 0; i < 10000; ++i) {
                    TextFrame frame;
                    int messageId = i;
                    FutureWriteCallback callback = new FutureWriteCallback();
                    if (i % 2 == 0) {
                        frame = new TextFrame().setPayload(largeMessage);
                        frameCount += 10;
                    } else {
                        frame = new TextFrame().setPayload("Short Message: " + i);
                        ++frameCount;
                    }
                    ext.outgoingFrame((Frame)frame, (WriteCallback)callback, batchMode);
                    callback.get();
                }
                enqueuedFrameCountFut.complete(frameCount);
            }
            catch (Throwable t) {
                enqueuedFrameCountFut.completeExceptionally(t);
            }
        });
        int enqueuedFrameCount = (Integer)enqueuedFrameCountFut.get(5L, TimeUnit.SECONDS);
        int expectedFrameCount = 50000;
        MatcherAssert.assertThat((String)"Saw expected frame count", (Object)saneFrameOrderingAssertion.frameCount, (Matcher)Matchers.is((Object)(expectedFrameCount += 5000)));
        MatcherAssert.assertThat((String)"Enqueued expected frame count", (Object)enqueuedFrameCount, (Matcher)Matchers.is((Object)expectedFrameCount));
    }
}

