/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.MessageTooLargeException;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ByteAccumulatorTest {
    @Test
    public void testCopyNormal() {
        ByteAccumulator accumulator = new ByteAccumulator(10000);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        byte[] space = " ".getBytes(StandardCharsets.UTF_8);
        byte[] world = "World".getBytes(StandardCharsets.UTF_8);
        accumulator.copyChunk(hello, 0, hello.length);
        accumulator.copyChunk(space, 0, space.length);
        accumulator.copyChunk(world, 0, world.length);
        MatcherAssert.assertThat((String)"Length", (Object)accumulator.getLength(), (Matcher)Matchers.is((Object)(hello.length + space.length + world.length)));
        ByteBuffer out = ByteBuffer.allocate(200);
        accumulator.transferTo(out);
        String result = BufferUtil.toUTF8String((ByteBuffer)out);
        MatcherAssert.assertThat((String)"ByteBuffer to UTF8", (Object)result, (Matcher)Matchers.is((Object)"Hello World"));
    }

    @Test
    public void testTransferToNotEnoughSpace() {
        ByteAccumulator accumulator = new ByteAccumulator(10000);
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        byte[] space = " ".getBytes(StandardCharsets.UTF_8);
        byte[] world = "World".getBytes(StandardCharsets.UTF_8);
        accumulator.copyChunk(hello, 0, hello.length);
        accumulator.copyChunk(space, 0, space.length);
        accumulator.copyChunk(world, 0, world.length);
        int length = hello.length + space.length + world.length;
        MatcherAssert.assertThat((String)"Length", (Object)accumulator.getLength(), (Matcher)Matchers.is((Object)length));
        ByteBuffer out = ByteBuffer.allocate(length - 2);
        IllegalArgumentException e = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> accumulator.transferTo(out));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Not enough space in ByteBuffer"));
    }

    @Test
    public void testCopyChunkNotEnoughSpace() {
        byte[] hello = "Hello".getBytes(StandardCharsets.UTF_8);
        byte[] space = " ".getBytes(StandardCharsets.UTF_8);
        byte[] world = "World".getBytes(StandardCharsets.UTF_8);
        int length = hello.length + space.length + world.length;
        ByteAccumulator accumulator = new ByteAccumulator(length - 2);
        accumulator.copyChunk(hello, 0, hello.length);
        accumulator.copyChunk(space, 0, space.length);
        MessageTooLargeException e = (MessageTooLargeException)Assertions.assertThrows(MessageTooLargeException.class, () -> accumulator.copyChunk(world, 0, world.length));
        MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"too large for configured max"));
    }
}

