/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.compression.DeflaterPool;
import org.eclipse.jetty.util.compression.InflaterPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtensionTest;
import org.eclipse.jetty.websocket.common.extensions.ExtensionTool;
import org.eclipse.jetty.websocket.common.extensions.compress.CapturedHexPayloads;
import org.eclipse.jetty.websocket.common.extensions.compress.DeflateFrameExtension;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.IncomingFramesCapture;
import org.eclipse.jetty.websocket.common.test.OutgoingNetworkBytesCapture;
import org.eclipse.jetty.websocket.common.test.UnitParser;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DeflateFrameExtensionTest
extends AbstractExtensionTest {
    private static final Logger LOG = Log.getLogger(DeflateFrameExtensionTest.class);
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    public DeflaterPool deflaterPool = new DeflaterPool(-1, -1, true);
    public InflaterPool inflaterPool = new InflaterPool(-1, true);

    private void assertIncoming(byte[] raw, String ... expectedTextDatas) {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        DeflateFrameExtension ext = new DeflateFrameExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(policy);
        ExtensionConfig config = ExtensionConfig.parse((String)"deflate-frame");
        ext.setConfig(config);
        IncomingFramesCapture capture = new IncomingFramesCapture();
        ext.setNextIncomingFrames((IncomingFrames)capture);
        UnitParser parser = new UnitParser(policy);
        parser.configureFromExtensions(Collections.singletonList(ext));
        parser.setIncomingFramesHandler((IncomingFrames)ext);
        parser.parse(ByteBuffer.wrap(raw));
        int len = expectedTextDatas.length;
        capture.assertFrameCount(len);
        capture.assertHasFrame((byte)1, len);
        int i = 0;
        for (WebSocketFrame actual : capture.getFrames()) {
            String prefix = "Frame[" + i + "]";
            MatcherAssert.assertThat((String)(prefix + ".opcode"), (Object)actual.getOpCode(), (Matcher)Matchers.is((Object)1));
            MatcherAssert.assertThat((String)(prefix + ".fin"), (Object)actual.isFin(), (Matcher)Matchers.is((Object)true));
            MatcherAssert.assertThat((String)(prefix + ".rsv1"), (Object)actual.isRsv1(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv2"), (Object)actual.isRsv2(), (Matcher)Matchers.is((Object)false));
            MatcherAssert.assertThat((String)(prefix + ".rsv3"), (Object)actual.isRsv3(), (Matcher)Matchers.is((Object)false));
            ByteBuffer expected = BufferUtil.toBuffer((String)expectedTextDatas[i], (Charset)StandardCharsets.UTF_8);
            MatcherAssert.assertThat((String)(prefix + ".payloadLength"), (Object)actual.getPayloadLength(), (Matcher)Matchers.is((Object)expected.remaining()));
            ByteBufferAssert.assertEquals(prefix + ".payload", expected, actual.getPayload().slice());
            ++i;
        }
    }

    private void assertOutgoing(String text, String expectedHex) throws IOException {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        DeflateFrameExtension ext = new DeflateFrameExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(policy);
        ExtensionConfig config = ExtensionConfig.parse((String)"deflate-frame");
        ext.setConfig(config);
        Generator generator = new Generator(policy, this.bufferPool, true);
        generator.configureFromExtensions(Collections.singletonList(ext));
        OutgoingNetworkBytesCapture capture = new OutgoingNetworkBytesCapture(generator);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        TextFrame frame = new TextFrame().setPayload(text);
        ext.outgoingFrame((Frame)frame, null, BatchMode.OFF);
        capture.assertBytes(0, expectedHex);
    }

    @Test
    public void testBlockheadClientHelloThere() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c18700000000f248cdc9c90700", "c187000000000ac9482d4a0500");
        tester.assertHasFrames("Hello", "There");
    }

    @Test
    public void testChrome20Hello() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c187832b5c11716391d84a2c5c");
        tester.assertHasFrames("Hello");
    }

    @Test
    public void testChrome20HelloThere() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c1877b1971db8951bc12b21e71", "c18759edc8f4532480d913e8c8");
        tester.assertHasFrames("Hello", "There");
    }

    @Test
    public void testChrome20Info() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c187ca4def7f0081a4b47d4fef");
        tester.assertHasFrames("info:");
    }

    @Test
    public void testChrome20TimeTime() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c18782467424a88fb869374474", "c1853cfda17f16fcb07f3c");
        tester.assertHasFrames("time:", "time:");
    }

    @Test
    public void testPyWebSocketTimeTimeTime() {
        ExtensionTool.Tester tester = this.serverExtensions.newTester("deflate-frame");
        tester.assertNegotiated("deflate-frame");
        tester.parseIncomingHex("c1876b10010441d9cd49de1201", "c1852ae3ff0100e2ee012a", "c18435558caa37468caa");
        tester.assertHasFrames("time:", "time:", "time:");
    }

    @Test
    public void testCompressTimeTimeTime() {
        Object[] expected = new String[]{"2AC9CC4DB50200", "2A01110000", "02130000"};
        CapturedHexPayloads capture = new CapturedHexPayloads();
        DeflateFrameExtension ext = new DeflateFrameExtension();
        this.init(ext);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        ext.outgoingFrame((Frame)new TextFrame().setPayload("time:"), null, BatchMode.OFF);
        ext.outgoingFrame((Frame)new TextFrame().setPayload("time:"), null, BatchMode.OFF);
        ext.outgoingFrame((Frame)new TextFrame().setPayload("time:"), null, BatchMode.OFF);
        List<String> actual = capture.getCaptured();
        MatcherAssert.assertThat((String)"Compressed Payloads", actual, (Matcher)Matchers.contains((Object[])expected));
    }

    private void init(DeflateFrameExtension ext) {
        ext.setConfig(new ExtensionConfig(ext.getName()));
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
    }

    @Test
    public void testDeflateBasics() {
        Deflater compressor = new Deflater(9, true);
        compressor.setStrategy(0);
        String text = "info:";
        byte[] uncompressed = StringUtil.getUtf8Bytes((String)text);
        compressor.reset();
        compressor.setInput(uncompressed, 0, uncompressed.length);
        compressor.finish();
        ByteBuffer outbuf = ByteBuffer.allocate(64);
        BufferUtil.clearToFill((ByteBuffer)outbuf);
        while (!compressor.finished()) {
            byte[] out = new byte[64];
            int len = compressor.deflate(out, 0, out.length, 2);
            if (len <= 0) continue;
            outbuf.put(out, 0, len);
        }
        compressor.end();
        BufferUtil.flipToFlush((ByteBuffer)outbuf, (int)0);
        byte[] compressed = BufferUtil.toArray((ByteBuffer)outbuf);
        compressed[0] = (byte)(compressed[0] & 0xFE);
        String actual = TypeUtil.toHexString((byte[])compressed);
        String expected = "CaCc4bCbB70200";
        MatcherAssert.assertThat((String)"Compressed data", (Object)actual, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testGeneratedTwoFrames() throws IOException {
        WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
        DeflateFrameExtension ext = new DeflateFrameExtension();
        ext.setBufferPool(this.bufferPool);
        ext.setDeflaterPool(this.deflaterPool);
        ext.setInflaterPool(this.inflaterPool);
        ext.setPolicy(policy);
        ext.setConfig(new ExtensionConfig(ext.getName()));
        Generator generator = new Generator(policy, this.bufferPool, true);
        generator.configureFromExtensions(Collections.singletonList(ext));
        OutgoingNetworkBytesCapture capture = new OutgoingNetworkBytesCapture(generator);
        ext.setNextOutgoingFrames((OutgoingFrames)capture);
        ext.outgoingFrame((Frame)new TextFrame().setPayload("Hello"), null, BatchMode.OFF);
        ext.outgoingFrame((Frame)new TextFrame(), null, BatchMode.OFF);
        ext.outgoingFrame((Frame)new TextFrame().setPayload("There"), null, BatchMode.OFF);
        capture.assertBytes(0, "c107f248cdc9c90700");
    }

    @Test
    public void testInflateBasics() throws Exception {
        byte[] rawbuf = TypeUtil.fromHexString((String)"CaCc4bCbB70200");
        Inflater inflater = new Inflater(true);
        inflater.reset();
        inflater.setInput(rawbuf, 0, rawbuf.length);
        byte[] outbuf = new byte[64];
        int len = inflater.inflate(outbuf);
        inflater.end();
        MatcherAssert.assertThat((String)"Inflated length", (Object)len, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(4)));
        String actual = StringUtil.toUTF8String((byte[])outbuf, (int)0, (int)len);
        MatcherAssert.assertThat((String)"Inflated text", (Object)actual, (Matcher)Matchers.is((Object)"info:"));
    }

    @Test
    public void testPyWebSocketServerHello() {
        byte[] rawbuf = TypeUtil.fromHexString((String)"c107f248cdc9c90700");
        this.assertIncoming(rawbuf, "Hello");
    }

    @Test
    public void testPyWebSocketServerLong() {
        byte[] rawbuf = TypeUtil.fromHexString((String)"c1421cca410a80300c44d1abccce9df7f018298634d05631138ab7b7b8fdef1fdc0282e2061d575a45f6f2686bab25e13fb7296fa02b5885eb3b0379c394f46198cafd03");
        this.assertIncoming(rawbuf, "It's a big enough umbrella but it's always me that ends up getting wet.");
    }

    @Test
    public void testPyWebSocketServerMedium() {
        byte[] rawbuf = TypeUtil.fromHexString((String)"c10f2a2e494ccece2f4b2d4acbc92f0700");
        this.assertIncoming(rawbuf, "stackoverflow");
    }

    @Test
    public void testServerGeneratedHello() throws IOException {
        this.assertOutgoing("Hello", "c107f248cdc9c90700");
    }

    @Test
    public void testServerGeneratedThere() throws IOException {
        this.assertOutgoing("There", "c1070ac9482d4a0500");
    }

    @Test
    public void testCompressAndDecompressBigPayload() throws Exception {
        byte[] input = new byte[0x100000];
        new Random().nextBytes(input);
        int maxMessageSize = 0x102000;
        DeflateFrameExtension clientExtension = new DeflateFrameExtension();
        clientExtension.setBufferPool(this.bufferPool);
        clientExtension.setDeflaterPool(this.deflaterPool);
        clientExtension.setInflaterPool(this.inflaterPool);
        clientExtension.setPolicy(WebSocketPolicy.newClientPolicy());
        clientExtension.getPolicy().setMaxBinaryMessageSize(maxMessageSize);
        clientExtension.getPolicy().setMaxBinaryMessageBufferSize(maxMessageSize);
        clientExtension.setConfig(ExtensionConfig.parse((String)"deflate-frame"));
        final DeflateFrameExtension serverExtension = new DeflateFrameExtension();
        serverExtension.setBufferPool(this.bufferPool);
        serverExtension.setDeflaterPool(this.deflaterPool);
        serverExtension.setInflaterPool(this.inflaterPool);
        serverExtension.setPolicy(WebSocketPolicy.newServerPolicy());
        serverExtension.getPolicy().setMaxBinaryMessageSize(maxMessageSize);
        serverExtension.getPolicy().setMaxBinaryMessageBufferSize(maxMessageSize);
        serverExtension.setConfig(ExtensionConfig.parse((String)"deflate-frame"));
        clientExtension.setNextOutgoingFrames(new OutgoingFrames(){

            public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
                LOG.debug("outgoingFrame({})", new Object[]{frame});
                serverExtension.incomingFrame(frame);
                callback.writeSuccess();
            }
        });
        final ByteArrayOutputStream result = new ByteArrayOutputStream(input.length);
        serverExtension.setNextIncomingFrames(new IncomingFrames(){

            public void incomingFrame(Frame frame) {
                LOG.debug("incomingFrame({})", new Object[]{frame});
                try {
                    result.write(BufferUtil.toArray((ByteBuffer)frame.getPayload()));
                }
                catch (IOException x) {
                    throw new RuntimeIOException((Throwable)x);
                }
            }
        });
        BinaryFrame frame = new BinaryFrame();
        frame.setPayload(input);
        frame.setFin(true);
        clientExtension.outgoingFrame((Frame)frame, null, BatchMode.OFF);
        Assertions.assertArrayEquals((byte[])input, (byte[])result.toByteArray());
    }
}

