/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import org.eclipse.jetty.websocket.common.io.ConnectionState;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ConnectionStateTest {
    @Test
    public void testHandshakeToOpened() {
        ConnectionState state = new ConnectionState();
        Assertions.assertFalse((boolean)state.canWriteWebSocketFrames(), (String)"Handshaking canWriteWebSocketFrames");
        Assertions.assertFalse((boolean)state.canReadWebSocketFrames(), (String)"Handshaking canReadWebSocketFrames");
        Assertions.assertTrue((boolean)state.opening(), (String)"Opening");
        Assertions.assertTrue((boolean)state.canWriteWebSocketFrames(), (String)"Opening canWriteWebSocketFrames");
        Assertions.assertFalse((boolean)state.canReadWebSocketFrames(), (String)"Opening canReadWebSocketFrames");
        Assertions.assertTrue((boolean)state.opened(), (String)"Opened");
        Assertions.assertTrue((boolean)state.canWriteWebSocketFrames(), (String)"Opened canWriteWebSocketFrames");
        Assertions.assertTrue((boolean)state.canReadWebSocketFrames(), (String)"Opened canReadWebSocketFrames");
    }

    @Test
    public void testOpenedClosing() {
        ConnectionState state = new ConnectionState();
        Assertions.assertTrue((boolean)state.opening(), (String)"Opening");
        Assertions.assertTrue((boolean)state.opened(), (String)"Opened");
        Assertions.assertTrue((boolean)state.closing(), (String)"Closing (initial)");
        Assertions.assertFalse((boolean)state.canWriteWebSocketFrames(), (String)"Closing canWriteWebSocketFrames");
        Assertions.assertTrue((boolean)state.canReadWebSocketFrames(), (String)"Closing canReadWebSocketFrames");
        Assertions.assertFalse((boolean)state.closing(), (String)"Closing (extra)");
    }

    @Test
    public void testOpenedClosingDisconnected() {
        ConnectionState state = new ConnectionState();
        Assertions.assertTrue((boolean)state.opening(), (String)"Opening");
        Assertions.assertTrue((boolean)state.opened(), (String)"Opened");
        Assertions.assertTrue((boolean)state.closing(), (String)"Closing");
        Assertions.assertTrue((boolean)state.disconnected(), (String)"Disconnected");
        Assertions.assertFalse((boolean)state.canWriteWebSocketFrames(), (String)"Disconnected canWriteWebSocketFrames");
        Assertions.assertFalse((boolean)state.canReadWebSocketFrames(), (String)"Disconnected canReadWebSocketFrames");
    }

    @Test
    public void testOpenedHarshDisconnected() {
        ConnectionState state = new ConnectionState();
        Assertions.assertTrue((boolean)state.opening(), (String)"Opening");
        Assertions.assertTrue((boolean)state.opened(), (String)"Opened");
        Assertions.assertTrue((boolean)state.disconnected(), (String)"Disconnected");
        Assertions.assertFalse((boolean)state.canWriteWebSocketFrames(), (String)"Disconnected canWriteWebSocketFrames");
        Assertions.assertFalse((boolean)state.canReadWebSocketFrames(), (String)"Disconnected canReadWebSocketFrames");
    }
}

