/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritePendingException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.CloseFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.FrameFlusher;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;
import org.eclipse.jetty.websocket.common.io.MockEndPoint;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class FrameFlusherTest {
    public ByteBufferPool bufferPool = new MappedByteBufferPool();

    @Test
    public void testPostCloseFrameCallbacks() throws ExecutionException, InterruptedException, TimeoutException {
        WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
        Generator generator = new Generator(policy, this.bufferPool);
        CapturingEndPoint endPoint = new CapturingEndPoint(WebSocketPolicy.newClientPolicy(), this.bufferPool);
        int bufferSize = policy.getMaxBinaryMessageBufferSize();
        int maxGather = 1;
        FrameFlusher frameFlusher = new FrameFlusher(this.bufferPool, generator, (EndPoint)endPoint, bufferSize, maxGather);
        BatchMode batchMode = BatchMode.OFF;
        CloseFrame closeFrame = new CloseInfo(1009, "Message be to big").asFrame();
        WebSocketFrame textFrame = new TextFrame().setPayload("Hello").setFin(true);
        FutureWriteCallback closeCallback = new FutureWriteCallback();
        FutureWriteCallback textFrameCallback = new FutureWriteCallback();
        Assertions.assertTrue((boolean)frameFlusher.enqueue((Frame)closeFrame, (WriteCallback)closeCallback, batchMode));
        Assertions.assertFalse((boolean)frameFlusher.enqueue((Frame)textFrame, (WriteCallback)textFrameCallback, batchMode));
        frameFlusher.iterate();
        closeCallback.get(5L, TimeUnit.SECONDS);
        ExecutionException x = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> textFrameCallback.get(5L, TimeUnit.SECONDS));
        MatcherAssert.assertThat((Object)x.getCause(), (Matcher)Matchers.instanceOf(ClosedChannelException.class));
    }

    @Test
    public void testLargeSmallText() throws ExecutionException, InterruptedException {
        WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
        Generator generator = new Generator(policy, this.bufferPool);
        CapturingEndPoint endPoint = new CapturingEndPoint(WebSocketPolicy.newClientPolicy(), this.bufferPool);
        int bufferSize = policy.getMaxBinaryMessageBufferSize();
        int maxGather = 8;
        FrameFlusher frameFlusher = new FrameFlusher(this.bufferPool, generator, (EndPoint)endPoint, bufferSize, maxGather);
        int largeMessageSize = 60000;
        byte[] buf = new byte[largeMessageSize];
        Arrays.fill(buf, (byte)120);
        String largeMessage = new String(buf, StandardCharsets.UTF_8);
        int messageCount = 10000;
        BatchMode batchMode = BatchMode.OFF;
        CompletableFuture serverTask = new CompletableFuture();
        CompletableFuture.runAsync(() -> {
            try {
                for (int i = 0; i < messageCount; ++i) {
                    FutureWriteCallback callback = new FutureWriteCallback();
                    TextFrame frame = i % 2 == 0 ? new TextFrame().setPayload(largeMessage) : new TextFrame().setPayload("Short Message: " + i);
                    frameFlusher.enqueue((Frame)frame, (WriteCallback)callback, batchMode);
                    frameFlusher.iterate();
                    callback.get();
                }
            }
            catch (Throwable t) {
                serverTask.completeExceptionally(t);
            }
            serverTask.complete(null);
        });
        serverTask.get();
        System.out.printf("Received: %,d frames%n", endPoint.incomingFrames.size());
    }

    public static class CapturingEndPoint
    extends MockEndPoint
    implements IncomingFrames {
        public Parser parser;
        public LinkedBlockingQueue<Frame> incomingFrames = new LinkedBlockingQueue();

        public CapturingEndPoint(WebSocketPolicy policy, ByteBufferPool bufferPool) {
            this.parser = new Parser(policy, bufferPool);
            this.parser.setIncomingFramesHandler((IncomingFrames)this);
        }

        public void incomingFrame(Frame frame) {
            this.incomingFrames.offer(frame);
        }

        @Override
        public void shutdownOutput() {
        }

        @Override
        public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
            Objects.requireNonNull(callback);
            try {
                for (ByteBuffer buffer : buffers) {
                    this.parser.parse(buffer);
                }
                callback.succeeded();
            }
            catch (WritePendingException e) {
                throw e;
            }
            catch (Throwable t) {
                callback.failed(t);
            }
        }
    }
}

