/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ExecutorThreadPool;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.CloseException;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.io.ConnectionState;

public class LocalWebSocketConnection
implements LogicalConnection,
IncomingFrames {
    private static final Logger LOG = Log.getLogger(LocalWebSocketConnection.class);
    private final String id;
    private final ByteBufferPool bufferPool;
    private final Executor executor;
    private final ConnectionState connectionState = new ConnectionState();
    private WebSocketSession session;
    private WebSocketPolicy policy = WebSocketPolicy.newServerPolicy();
    private IncomingFrames incoming;

    public LocalWebSocketConnection(ByteBufferPool bufferPool) {
        this("anon", bufferPool);
    }

    public LocalWebSocketConnection(String id, ByteBufferPool bufferPool) {
        this.id = id;
        this.bufferPool = bufferPool;
        this.executor = new ExecutorThreadPool();
    }

    public boolean canReadWebSocketFrames() {
        return this.connectionState.canReadWebSocketFrames();
    }

    public boolean canWriteWebSocketFrames() {
        return this.connectionState.canWriteWebSocketFrames();
    }

    public void close(Throwable cause) {
        Callback callback = Callback.NOOP;
        if (cause instanceof CloseException) {
            callback = new DisconnectCallback();
        }
        this.close(cause, callback);
    }

    public void close(CloseInfo close, Callback callback) {
        if (this.connectionState.closing()) {
            this.session.callApplicationOnClose(close);
            this.disconnect();
        } else if (callback != null) {
            callback.failed((Throwable)new IllegalStateException("Local Close already called"));
        }
    }

    public void disconnect() {
        this.connectionState.disconnected();
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public String getId() {
        return this.id;
    }

    public long getIdleTimeout() {
        return 0L;
    }

    public IncomingFrames getIncoming() {
        return this.incoming;
    }

    public InetSocketAddress getLocalAddress() {
        return null;
    }

    public long getMaxIdleTimeout() {
        return 0L;
    }

    public void setMaxIdleTimeout(long ms) {
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public void setPolicy(WebSocketPolicy policy) {
        this.policy = policy;
    }

    public InetSocketAddress getRemoteAddress() {
        return null;
    }

    public void incomingFrame(Frame frame) {
        this.incoming.incomingFrame(frame);
    }

    public boolean isOpen() {
        return true;
    }

    public boolean isReading() {
        return false;
    }

    public boolean opened() {
        return this.connectionState.opened();
    }

    public boolean opening() {
        return this.connectionState.opening();
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
    }

    public void remoteClose(CloseInfo close) {
        this.close(close, Callback.NOOP);
    }

    public void resume() {
    }

    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.incoming = incoming;
    }

    public void setSession(WebSocketSession session) {
        this.session = session;
    }

    public SuspendToken suspend() {
        return null;
    }

    public String toStateString() {
        return this.connectionState.toString();
    }

    public String toString() {
        return String.format("%s[%s]", LocalWebSocketConnection.class.getSimpleName(), this.id);
    }

    private void close(Throwable cause, Callback callback) {
        this.session.callApplicationOnError(cause);
        this.close(new CloseInfo(1011, cause.getMessage()), callback);
    }

    private class CallbackBridge
    implements WriteCallback {
        final Callback callback;

        public CallbackBridge(Callback callback) {
            this.callback = callback;
        }

        public void writeFailed(Throwable x) {
            this.callback.failed(x);
        }

        public void writeSuccess() {
            this.callback.succeeded();
        }
    }

    private class DisconnectCallback
    implements Callback {
        private DisconnectCallback() {
        }

        public void failed(Throwable x) {
            LocalWebSocketConnection.this.disconnect();
        }

        public void succeeded() {
            LocalWebSocketConnection.this.disconnect();
        }
    }
}

