/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.io.ReadState;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ReadStateTest {
    @Test
    public void testReading() {
        ReadState readState = new ReadState();
        MatcherAssert.assertThat((String)"Initially reading", (Object)readState.isReading(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((String)"Action is reading", (Object)readState.getAction(BufferUtil.toBuffer((String)"content")), (Matcher)Matchers.is((Object)ReadState.Action.PARSE));
        MatcherAssert.assertThat((String)"No prior suspending", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ReadState)readState).resume(), (String)"No suspending to resume");
        MatcherAssert.assertThat((String)"No suspending to resume", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSuspendingThenResume() {
        ReadState readState = new ReadState();
        MatcherAssert.assertThat((String)"Initially reading", (Object)readState.isReading(), (Matcher)Matchers.is((Object)true));
        readState.suspending();
        MatcherAssert.assertThat((String)"Suspending doesn't take effect immediately", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
        Assertions.assertNull((Object)readState.resume());
        MatcherAssert.assertThat((String)"Action is reading", (Object)readState.getAction(BufferUtil.toBuffer((String)"content")), (Matcher)Matchers.is((Object)ReadState.Action.PARSE));
        MatcherAssert.assertThat((String)"Suspending was discarded", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testSuspendingThenSuspendThenResume() {
        ReadState readState = new ReadState();
        MatcherAssert.assertThat((String)"Initially reading", (Object)readState.isReading(), (Matcher)Matchers.is((Object)true));
        readState.suspending();
        MatcherAssert.assertThat((String)"Suspending doesn't take effect immediately", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
        ByteBuffer content = BufferUtil.toBuffer((String)"content");
        MatcherAssert.assertThat((Object)readState.getAction(content), (Matcher)Matchers.is((Object)ReadState.Action.SUSPEND));
        MatcherAssert.assertThat((String)"Suspended", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)readState.resume(), (Matcher)Matchers.is((Object)content));
        MatcherAssert.assertThat((String)"Resumed", (Object)readState.isSuspended(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testEof() {
        ReadState readState = new ReadState();
        ByteBuffer content = BufferUtil.toBuffer((String)"content");
        readState.eof();
        MatcherAssert.assertThat((Object)readState.isReading(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)readState.isSuspended(), (Matcher)Matchers.is((Object)true));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ReadState)readState).suspending());
        MatcherAssert.assertThat((Object)readState.getAction(content), (Matcher)Matchers.is((Object)ReadState.Action.EOF));
        Assertions.assertThrows(IllegalStateException.class, () -> ((ReadState)readState).resume());
    }
}

