/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io.payload;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.payload.DeMaskProcessor;
import org.eclipse.jetty.websocket.common.test.ByteBufferAssert;
import org.eclipse.jetty.websocket.common.test.UnitGenerator;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class DeMaskProcessorTest {
    private static final Logger LOG = Log.getLogger(DeMaskProcessorTest.class);

    @Test
    public void testDeMaskText() {
        String message = "0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF0123456789ABCDEF01";
        TextFrame frame = new TextFrame().setPayload(message);
        frame.setMask(TypeUtil.fromHexString((String)"11223344"));
        ByteBuffer buf = UnitGenerator.generate((Frame)frame);
        LOG.debug("Buf: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buf)});
        ByteBuffer payload = buf.slice();
        payload.position(6);
        LOG.debug("Payload: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
        DeMaskProcessor demask = new DeMaskProcessor();
        demask.reset((Frame)frame);
        demask.process(payload);
        ByteBufferAssert.assertEquals("DeMasked Text Payload", message, payload);
    }

    @Test
    public void testDeMaskTextSliced() {
        int msgChar = 42;
        int messageSize = 25;
        byte[] message = new byte[25];
        Arrays.fill(message, (byte)42);
        TextFrame frame = new TextFrame();
        frame.setPayload(ByteBuffer.wrap(message));
        frame.setMask(Hex.asByteArray("11223344"));
        ByteBuffer buf = UnitGenerator.generate((Frame)frame);
        LOG.debug("Buf: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buf)});
        ByteBuffer payload = buf.slice();
        payload.position(6);
        LOG.debug("Payload: {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)payload)});
        LOG.debug("Pre-Processed: {}", new Object[]{Hex.asHex(payload)});
        DeMaskProcessor demask = new DeMaskProcessor();
        demask.reset((Frame)frame);
        ByteBuffer slice1 = payload.slice();
        ByteBuffer slice2 = payload.slice();
        int slicePoint = 7;
        slice1.limit(slicePoint);
        slice2.position(slicePoint);
        MatcherAssert.assertThat((String)"Slices are setup right", (Object)(slice1.remaining() + slice2.remaining()), (Matcher)Matchers.is((Object)25));
        demask.process(slice1);
        demask.process(slice2);
        LOG.debug("Post-Processed: {}", new Object[]{Hex.asHex(payload)});
        MatcherAssert.assertThat((String)"Payload.remaining", (Object)payload.remaining(), (Matcher)Matchers.is((Object)25));
        for (int i = payload.position(); i < payload.limit(); ++i) {
            MatcherAssert.assertThat((String)("payload[" + i + "]"), (Object)payload.get(i), (Matcher)Matchers.is((Object)42));
        }
    }
}

