/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.util.Arrays;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.io.FramePipes;
import org.eclipse.jetty.websocket.common.io.LocalWebSocketSession;
import org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.eclipse.jetty.websocket.common.message.TrackingSocket;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class MessageOutputStreamTest {
    private static final Logger LOG = Log.getLogger(MessageOutputStreamTest.class);
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    private WebSocketPolicy policy;
    private TrackingSocket socket;
    private LocalWebSocketSession session;

    @AfterEach
    public void closeSession() throws Exception {
        this.session.close();
        this.session.stop();
    }

    @BeforeEach
    public void setupSession(TestInfo testInfo) throws Exception {
        this.policy = WebSocketPolicy.newServerPolicy();
        this.policy.setInputBufferSize(1024);
        this.policy.setMaxBinaryMessageBufferSize(1024);
        SimpleContainerScope containerScope = new SimpleContainerScope(this.policy, this.bufferPool);
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)containerScope);
        EventDriver driver = factory.wrap((Object)new TrackingSocket("local"));
        this.socket = new TrackingSocket("remote");
        OutgoingFrames socketPipe = FramePipes.to((IncomingFrames)factory.wrap((Object)this.socket));
        String id = testInfo.getDisplayName();
        this.session = new LocalWebSocketSession((WebSocketContainerScope)containerScope, id, driver);
        this.session.setPolicy(this.policy);
        this.session.setOutgoingHandler(socketPipe);
        this.session.start();
        this.session.open();
    }

    @Test
    public void testMultipleWrites() throws Exception {
        try (MessageOutputStream stream = new MessageOutputStream((WebSocketSession)this.session);){
            stream.write("Hello".getBytes("UTF-8"));
            stream.write(" ".getBytes("UTF-8"));
            stream.write("World".getBytes("UTF-8"));
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"byte[11]"), (Matcher)Matchers.containsString((String)"Hello World")));
    }

    @Test
    public void testSingleWrite() throws Exception {
        try (MessageOutputStream stream = new MessageOutputStream((WebSocketSession)this.session);){
            stream.write("Hello World".getBytes("UTF-8"));
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)"byte[11]"), (Matcher)Matchers.containsString((String)"Hello World")));
    }

    @Test
    public void testWriteMultipleBuffers() throws Exception {
        int bufsize = (int)((double)this.policy.getMaxBinaryMessageBufferSize() * 2.5);
        byte[] buf = new byte[bufsize];
        LOG.debug("Buffer sizes: max:{}, test:{}", new Object[]{this.policy.getMaxBinaryMessageBufferSize(), bufsize});
        Arrays.fill(buf, (byte)120);
        buf[bufsize - 1] = 111;
        try (MessageOutputStream stream = new MessageOutputStream((WebSocketSession)this.session);){
            stream.write(buf);
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.allOf((Matcher)Matchers.containsString((String)("byte[" + bufsize + "]")), (Matcher)Matchers.containsString((String)"xxxo>>>")));
    }
}

