/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.message;

import java.util.Arrays;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.io.FramePipes;
import org.eclipse.jetty.websocket.common.io.LocalWebSocketSession;
import org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.eclipse.jetty.websocket.common.message.TrackingSocket;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class MessageWriterTest {
    private static final Logger LOG = Log.getLogger(MessageWriterTest.class);
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    private WebSocketPolicy policy;
    private TrackingSocket socket;
    private LocalWebSocketSession session;

    @AfterEach
    public void closeSession() throws Exception {
        this.session.close();
        this.session.stop();
    }

    @BeforeEach
    public void setupSession(TestInfo testInfo) throws Exception {
        this.policy = WebSocketPolicy.newServerPolicy();
        this.policy.setInputBufferSize(1024);
        this.policy.setMaxTextMessageBufferSize(1024);
        SimpleContainerScope containerScope = new SimpleContainerScope(this.policy, this.bufferPool);
        EventDriverFactory factory = new EventDriverFactory((WebSocketContainerScope)containerScope);
        EventDriver driver = factory.wrap((Object)new TrackingSocket("local"));
        this.socket = new TrackingSocket("remote");
        OutgoingFrames socketPipe = FramePipes.to((IncomingFrames)factory.wrap((Object)this.socket));
        String id = testInfo.getDisplayName();
        this.session = new LocalWebSocketSession((WebSocketContainerScope)containerScope, id, driver);
        this.session.setPolicy(this.policy);
        this.session.setOutgoingHandler(socketPipe);
        this.session.start();
        this.session.open();
    }

    @Test
    public void testMultipleWrites() throws Exception {
        try (MessageWriter stream = new MessageWriter((WebSocketSession)this.session);){
            stream.write("Hello");
            stream.write(" ");
            stream.write("World");
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.is((Object)"Hello World"));
    }

    @Test
    public void testSingleWrite() throws Exception {
        try (MessageWriter stream = new MessageWriter((WebSocketSession)this.session);){
            stream.append((CharSequence)"Hello World");
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.is((Object)"Hello World"));
    }

    @Test
    public void testWriteMultipleBuffers() throws Exception {
        int bufsize = (int)((double)this.policy.getMaxTextMessageBufferSize() * 2.5);
        char[] buf = new char[bufsize];
        if (LOG.isDebugEnabled()) {
            LOG.debug("Buffer size: {}", (long)bufsize);
        }
        Arrays.fill(buf, 'x');
        buf[bufsize - 1] = 111;
        try (MessageWriter stream = new MessageWriter((WebSocketSession)this.session);){
            stream.write(buf);
        }
        MatcherAssert.assertThat((String)"Socket.messageQueue.size", (Object)this.socket.messageQueue.size(), (Matcher)Matchers.is((Object)1));
        String msg = this.socket.messageQueue.poll();
        String expected = new String(buf);
        MatcherAssert.assertThat((String)"Message", (Object)msg, (Matcher)Matchers.is((Object)expected));
    }
}

