/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.net.ConnectException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionUpgrader;
import org.eclipse.jetty.client.util.ByteBufferContentProvider;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientConnection;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;

public class BlockheadClientRequest
extends HttpRequest
implements Response.CompleteListener,
HttpConnectionUpgrader {
    private static final Logger LOG = Log.getLogger(BlockheadClientRequest.class);
    private final BlockheadClient client;
    private final CompletableFuture<BlockheadConnection> fut;

    protected BlockheadClientRequest(BlockheadClient client, URI uri) {
        super((HttpClient)client, new HttpConversation(), uri);
        this.client = client;
        this.fut = new CompletableFuture();
        this.getConversation().setAttribute(HttpConnectionUpgrader.class.getName(), (Object)this);
    }

    public void setInitialBytes(ByteBuffer initialBytes) {
        this.content((ContentProvider)new RawBytesProvider(initialBytes));
    }

    private final String genRandomKey() {
        byte[] bytes = new byte[16];
        ThreadLocalRandom.current().nextBytes(bytes);
        return Base64.getEncoder().encodeToString(bytes);
    }

    private void initWebSocketHeaders() {
        this.method(HttpMethod.GET);
        this.version(HttpVersion.HTTP_1_1);
        HttpFields fields = this.getHeaders();
        if (!fields.contains(HttpHeader.UPGRADE)) {
            this.header(HttpHeader.UPGRADE, "websocket");
        }
        if (!fields.contains(HttpHeader.CONNECTION)) {
            this.header(HttpHeader.CONNECTION, "Upgrade");
        }
        if (!fields.contains(HttpHeader.SEC_WEBSOCKET_KEY)) {
            this.header(HttpHeader.SEC_WEBSOCKET_KEY, this.genRandomKey());
        }
        if (!fields.contains(HttpHeader.SEC_WEBSOCKET_VERSION)) {
            this.header(HttpHeader.SEC_WEBSOCKET_VERSION, "13");
        }
        if (!fields.contains(HttpHeader.PRAGMA)) {
            this.header(HttpHeader.PRAGMA, "no-cache");
        }
        if (!fields.contains(HttpHeader.CACHE_CONTROL)) {
            this.header(HttpHeader.CACHE_CONTROL, "no-cache");
        }
    }

    public ContentResponse send() throws InterruptedException, TimeoutException, ExecutionException {
        throw new RuntimeException("Working with raw ContentResponse is invalid for WebSocket");
    }

    public void send(Response.CompleteListener listener) {
        this.initWebSocketHeaders();
        super.send(listener);
    }

    public CompletableFuture<BlockheadConnection> sendAsync() {
        this.send(this);
        return this.fut;
    }

    public void onComplete(Result result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onComplete() - {}", new Object[]{result});
        }
        URI requestURI = result.getRequest().getURI();
        Response response = result.getResponse();
        int responseStatusCode = response.getStatus();
        String responseLine = responseStatusCode + " " + response.getReason();
        if (result.isFailed()) {
            Throwable failure;
            if (LOG.isDebugEnabled()) {
                if (result.getFailure() != null) {
                    LOG.debug("General Failure", result.getFailure());
                }
                if (result.getRequestFailure() != null) {
                    LOG.debug("Request Failure", result.getRequestFailure());
                }
                if (result.getResponseFailure() != null) {
                    LOG.debug("Response Failure", result.getResponseFailure());
                }
            }
            if ((failure = result.getFailure()) instanceof ConnectException || failure instanceof UpgradeException) {
                this.handleException(failure);
            } else {
                this.handleException((Throwable)new UpgradeException(requestURI, responseStatusCode, responseLine, failure));
            }
        }
        if (responseStatusCode != 101) {
            this.handleException((Throwable)new UpgradeException(requestURI, responseStatusCode, responseLine));
        }
    }

    private void handleException(Throwable failure) {
        this.fut.completeExceptionally(failure);
    }

    public void upgrade(HttpResponse response, HttpConnectionOverHTTP oldConn) {
        String[] extValues;
        String respHash;
        if (!this.getHeaders().get(HttpHeader.UPGRADE).equalsIgnoreCase("websocket")) {
            throw new HttpResponseException("Not WebSocket Upgrade", (Response)response);
        }
        String reqKey = this.getHeaders().get(HttpHeader.SEC_WEBSOCKET_KEY);
        String expectedHash = AcceptHash.hashKey((String)reqKey);
        if (!expectedHash.equalsIgnoreCase(respHash = response.getHeaders().get(HttpHeader.SEC_WEBSOCKET_ACCEPT))) {
            throw new HttpResponseException("Invalid Sec-WebSocket-Accept hash", (Response)response);
        }
        EndPoint endp = oldConn.getEndPoint();
        ExtensionStack extensionStack = new ExtensionStack(this.client.getExtensionFactory());
        ArrayList<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>();
        HttpField extField = response.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (extField != null && (extValues = extField.getValues()) != null) {
            for (String extVal : extValues) {
                QuotedStringTokenizer tok = new QuotedStringTokenizer(extVal, ",");
                while (tok.hasMoreTokens()) {
                    extensions.add(ExtensionConfig.parse((String)tok.nextToken()));
                }
            }
        }
        extensionStack.negotiate(extensions);
        BlockheadClientConnection connection = new BlockheadClientConnection(this.client.getPolicy(), this.client.getBufferPool(), extensionStack, this.fut, endp, this.client.getExecutor());
        endp.setIdleTimeout(this.client.getIdleTimeout());
        connection.setUpgradeRequestHeaders(this.getHeaders());
        connection.setUpgradeResponseHeaders(response.getHeaders());
        endp.upgrade((Connection)connection);
    }

    public static class RawBytesProvider
    extends ByteBufferContentProvider {
        public RawBytesProvider(ByteBuffer buf) {
            super(new ByteBuffer[]{buf});
        }

        public String getContentType() {
            return null;
        }
    }
}

