/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Consumer;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.test.WriteCallbackDelegate;

public class BlockheadConnection
extends AbstractConnection
implements Connection.UpgradeTo {
    private static final int BUFFER_SIZE = 4096;
    public static final String STATIC_REQUEST_HASH_KEY = "dGhlIHNhbXBsZSBub25jZQ==";
    private final Logger log = Log.getLogger(((Object)((Object)this)).getClass());
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private final Parser parser;
    private final Generator generator;
    private final ExtensionStack extensionStack;
    private final OutgoingNetwork networkOutgoing;
    private final IncomingCapture incomingCapture;
    private final CompletableFuture<BlockheadConnection> openFuture;
    private ByteBuffer networkBuffer;
    private HttpFields upgradeResponseHeaders;
    private HttpFields upgradeRequestHeaders;

    public BlockheadConnection(WebSocketPolicy policy, ByteBufferPool bufferPool, ExtensionStack extensionStack, CompletableFuture<BlockheadConnection> openFut, EndPoint endp, Executor executor) {
        super(endp, executor);
        this.policy = policy;
        this.bufferPool = bufferPool;
        this.parser = new Parser(policy, bufferPool);
        this.generator = new Generator(policy, bufferPool, false);
        this.extensionStack = extensionStack;
        this.openFuture = openFut;
        this.extensionStack.configure(this.parser);
        this.extensionStack.configure(this.generator);
        this.parser.setIncomingFramesHandler((IncomingFrames)extensionStack);
        this.incomingCapture = new IncomingCapture();
        this.extensionStack.setNextIncoming((IncomingFrames)this.incomingCapture);
        this.networkOutgoing = new OutgoingNetwork();
        extensionStack.setNextOutgoing((OutgoingFrames)this.networkOutgoing);
        try {
            extensionStack.start();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to start ExtensionStack", e);
        }
    }

    public void abort() {
        EndPoint endPoint = this.getEndPoint();
        endPoint.shutdownOutput();
        endPoint.close();
    }

    public void fillInterested() {
        if (BufferUtil.hasContent((ByteBuffer)this.networkBuffer)) {
            this.fillAndParse();
        } else {
            super.fillInterested();
        }
    }

    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public LinkedBlockingQueue<WebSocketFrame> getFrameQueue() {
        return this.incomingCapture.incomingFrames;
    }

    public Generator getGenerator() {
        return this.generator;
    }

    public InetSocketAddress getLocalSocketAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    public Parser getParser() {
        return this.parser;
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    public HttpFields getUpgradeRequestHeaders() {
        return this.upgradeRequestHeaders;
    }

    public HttpFields getUpgradeResponseHeaders() {
        return this.upgradeResponseHeaders;
    }

    public boolean isOpen() {
        return this.getEndPoint().isOpen();
    }

    public void onFillable() {
        this.getNetworkBuffer();
        this.fillAndParse();
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        this.setInitialBuffer(buffer);
    }

    public void onOpen() {
        super.onOpen();
        if (this.openFuture != null) {
            this.openFuture.complete(this);
        }
        this.fillInterested();
    }

    public void processConnectionError(Throwable cause) {
        this.log.warn("Connection Error", cause);
        if (this.openFuture != null) {
            this.openFuture.completeExceptionally(cause);
        }
    }

    public void setUpgradeRequestHeaders(HttpFields upgradeRequestHeaders) {
        this.upgradeRequestHeaders = new HttpFields(upgradeRequestHeaders);
    }

    public void setUpgradeResponseHeaders(HttpFields upgradeResponseHeaders) {
        this.upgradeResponseHeaders = new HttpFields(upgradeResponseHeaders);
    }

    public void setIncomingFrameConsumer(Consumer<Frame> consumer) {
        this.incomingCapture.frameConsumer = consumer;
    }

    public void write(WebSocketFrame frame) {
        this.networkOutgoing.outgoingFrame((Frame)frame, null, BatchMode.OFF);
    }

    public void writeRaw(ByteBuffer buf) throws IOException {
        boolean done = false;
        while (!done) {
            done = this.getEndPoint().flush(new ByteBuffer[]{buf});
        }
    }

    public void writeRaw(ByteBuffer buf, int numBytes) throws IOException {
        int len = Math.min(numBytes, buf.remaining());
        ByteBuffer slice = buf.slice();
        buf.limit(len);
        try {
            boolean done = false;
            while (!done) {
                done = this.getEndPoint().flush(new ByteBuffer[]{slice});
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            buf.position(buf.position() + len);
        }
    }

    public void writeRawSlowly(ByteBuffer buf, int segmentSize) throws IOException {
        while (buf.remaining() > 0) {
            this.writeRaw(buf, segmentSize);
        }
    }

    protected void setInitialBuffer(ByteBuffer initialBuffer) {
        if (BufferUtil.hasContent((ByteBuffer)initialBuffer)) {
            this.networkBuffer = this.bufferPool.acquire(initialBuffer.remaining(), true);
            BufferUtil.clearToFill((ByteBuffer)this.networkBuffer);
            BufferUtil.put((ByteBuffer)initialBuffer, (ByteBuffer)this.networkBuffer);
            BufferUtil.flipToFlush((ByteBuffer)this.networkBuffer, (int)0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillAndParse() {
        boolean interested = false;
        try {
            while (this.getEndPoint().isOpen()) {
                ByteBuffer nBuffer = this.getNetworkBuffer();
                this.parser.parse(nBuffer);
                assert (!nBuffer.hasRemaining());
                int filled = this.getEndPoint().fill(nBuffer);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("endpointFill() filled={}: {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)nBuffer)});
                }
                if (filled < 0) {
                    this.releaseNetworkBuffer(nBuffer);
                    return;
                }
                if (filled != 0) continue;
                this.releaseNetworkBuffer(nBuffer);
                interested = true;
                return;
            }
        }
        catch (Throwable t) {
            this.processConnectionError(t);
        }
        finally {
            if (interested) {
                this.fillInterested();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteBuffer getNetworkBuffer() {
        BlockheadConnection blockheadConnection = this;
        synchronized (blockheadConnection) {
            if (this.networkBuffer == null) {
                this.networkBuffer = this.bufferPool.acquire(4096, true);
            }
            return this.networkBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseNetworkBuffer(ByteBuffer buffer) {
        BlockheadConnection blockheadConnection = this;
        synchronized (blockheadConnection) {
            assert (!buffer.hasRemaining());
            this.bufferPool.release(buffer);
            this.networkBuffer = null;
        }
    }

    public class OutgoingNetwork
    implements OutgoingFrames {
        public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
            ByteBuffer header = BlockheadConnection.this.generator.generateHeaderBytes(frame);
            ByteBuffer payload = frame.getPayload();
            if (payload == null) {
                payload = BufferUtil.EMPTY_BUFFER;
            }
            Callback jettyCallback = this.asJettyCallback(callback);
            try {
                BlockheadConnection.this.getEndPoint().flush(new ByteBuffer[]{header, payload});
                jettyCallback.succeeded();
            }
            catch (IOException e) {
                jettyCallback.failed((Throwable)e);
            }
        }

        private Callback asJettyCallback(WriteCallback writeCallback) {
            if (writeCallback instanceof Callback) {
                return (Callback)writeCallback;
            }
            return new WriteCallbackDelegate(writeCallback);
        }
    }

    public class IncomingCapture
    implements IncomingFrames {
        public final LinkedBlockingQueue<WebSocketFrame> incomingFrames = new LinkedBlockingQueue();
        public Consumer<Frame> frameConsumer;

        public void incomingFrame(Frame frame) {
            if (this.frameConsumer != null) {
                this.frameConsumer.accept(frame);
            }
            this.incomingFrames.offer(WebSocketFrame.copy((Frame)frame));
        }
    }
}

