/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.BiFunction;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.common.AcceptHash;
import org.eclipse.jetty.websocket.common.extensions.ExtensionStack;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.SimpleContainerScope;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.BlockheadServerConnection;

public class BlockheadServer {
    private static final Logger LOG = Log.getLogger(BlockheadServer.class);
    public static final String SEC_WEBSOCKET_EXTENSIONS = HttpHeader.SEC_WEBSOCKET_EXTENSIONS.toString();
    private final Server server = new Server();
    private final ServerConnector connector = new ServerConnector(this.server);
    private final BlockheadServerHandler serverHandler;
    private final WebSocketPolicy policy;
    private final WebSocketContainerScope websocketContainer;
    private final WebSocketExtensionFactory extensionFactory;
    private URI wsUri;

    public BlockheadServer() {
        this.connector.setPort(0);
        this.server.addConnector((Connector)this.connector);
        this.policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        this.websocketContainer = new SimpleContainerScope(this.policy);
        this.extensionFactory = new WebSocketExtensionFactory(this.websocketContainer);
        HandlerList handlers = new HandlerList();
        this.serverHandler = new BlockheadServerHandler(this.websocketContainer, this.extensionFactory);
        handlers.addHandler((Handler)this.serverHandler);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
    }

    public void addConnectFuture(CompletableFuture<BlockheadConnection> serverConnFut) {
        this.serverHandler.getWSConnectionFutures().offer(serverConnFut);
    }

    public WebSocketExtensionFactory getExtensionFactory() {
        return this.extensionFactory;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public WebSocketContainerScope getWebsocketContainer() {
        return this.websocketContainer;
    }

    public void setRequestHandling(BiFunction<Request, Response, Boolean> requestFunction) {
        this.serverHandler.setFunction(requestFunction);
    }

    public void resetRequestHandling() {
        this.serverHandler.setFunction(null);
    }

    public URI getWsUri() {
        return this.wsUri;
    }

    public void start() throws Exception {
        this.server.start();
        this.wsUri = URI.create("ws://localhost:" + this.connector.getLocalPort() + "/");
        LOG.debug("BlockheadServer available on {}", new Object[]{this.wsUri});
    }

    public void stop() throws Exception {
        LOG.debug("Stopping Server", new Object[0]);
        this.server.stop();
    }

    public static class BlockheadServerHandler
    extends AbstractHandler {
        private final WebSocketContainerScope container;
        private final WebSocketExtensionFactory extensionFactory;
        private BiFunction<Request, Response, Boolean> requestFunction;
        private LinkedBlockingQueue<CompletableFuture<BlockheadConnection>> futuresQueue;

        public BlockheadServerHandler(WebSocketContainerScope websocketContainer, WebSocketExtensionFactory extensionFactory) {
            this.container = websocketContainer;
            this.extensionFactory = extensionFactory;
            this.futuresQueue = new LinkedBlockingQueue();
        }

        public Queue<CompletableFuture<BlockheadConnection>> getWSConnectionFutures() {
            return this.futuresQueue;
        }

        public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            Response baseResponse = (Response)response;
            if (this.requestFunction != null && this.requestFunction.apply(baseRequest, baseResponse).booleanValue()) {
                baseRequest.setHandled(true);
                return;
            }
            CompletableFuture<BlockheadConnection> connFut = this.futuresQueue.poll();
            try {
                baseRequest.setHandled(true);
                String key = request.getHeader("Sec-WebSocket-Key");
                if (key == null) {
                    throw new IllegalStateException("Missing request header 'Sec-WebSocket-Key'");
                }
                response.setHeader("Upgrade", "WebSocket");
                response.addHeader("Connection", "Upgrade");
                response.addHeader("Sec-WebSocket-Accept", AcceptHash.hashKey((String)key));
                response.setStatus(101);
                ExtensionStack extensionStack = new ExtensionStack((ExtensionFactory)this.extensionFactory);
                if (response.containsHeader(SEC_WEBSOCKET_EXTENSIONS)) {
                    ArrayList extensionConfigs = new ArrayList();
                    response.getHeaders(SEC_WEBSOCKET_EXTENSIONS).forEach(value -> extensionConfigs.addAll(ExtensionConfig.parseList((String[])new String[]{value})));
                    extensionStack.negotiate(extensionConfigs);
                } else {
                    Enumeration e = request.getHeaders(SEC_WEBSOCKET_EXTENSIONS);
                    List extensionConfigs = ExtensionConfig.parseEnum((Enumeration)e);
                    extensionStack.negotiate(extensionConfigs);
                    String negotiatedHeaderValue = ExtensionConfig.toHeaderValue((List)extensionStack.getNegotiatedExtensions());
                    response.setHeader(SEC_WEBSOCKET_EXTENSIONS, negotiatedHeaderValue);
                }
                WebSocketPolicy policy = this.container.getPolicy().clonePolicy();
                HttpConnection http = (HttpConnection)request.getAttribute("org.eclipse.jetty.server.HttpConnection");
                EndPoint endp = http.getEndPoint();
                Connector connector = http.getConnector();
                Executor executor = connector.getExecutor();
                ByteBufferPool bufferPool = connector.getByteBufferPool();
                BlockheadServerConnection wsConnection = new BlockheadServerConnection(policy, bufferPool, extensionStack, connFut, endp, executor);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HttpConnection: {}", new Object[]{http});
                    LOG.debug("BlockheadServerConnection: {}", new Object[]{wsConnection});
                }
                wsConnection.setUpgradeRequestHeaders(baseRequest.getHttpFields());
                wsConnection.setUpgradeResponseHeaders(baseResponse.getHttpFields());
                request.setAttribute("org.eclipse.jetty.server.HttpConnection.UPGRADE", (Object)wsConnection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Websocket upgrade {} {}", new Object[]{request.getRequestURI(), wsConnection});
                }
            }
            catch (Throwable cause) {
                if (connFut != null) {
                    connFut.completeExceptionally(cause);
                }
                LOG.warn(cause);
            }
        }

        public void setFunction(BiFunction<Request, Response, Boolean> function) {
            this.requestFunction = function;
        }
    }
}

