/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.Generator;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class OutgoingNetworkBytesCapture
implements OutgoingFrames {
    private final Generator generator;
    private List<ByteBuffer> captured;

    public OutgoingNetworkBytesCapture(Generator generator) {
        this.generator = generator;
        this.captured = new ArrayList<ByteBuffer>();
    }

    public void assertBytes(int idx, String expectedHex) {
        MatcherAssert.assertThat((String)"Capture index does not exist", (Object)idx, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(this.captured.size())));
        ByteBuffer buf = this.captured.get(idx);
        String actualHex = TypeUtil.toHexString((byte[])BufferUtil.toArray((ByteBuffer)buf)).toUpperCase(Locale.ENGLISH);
        MatcherAssert.assertThat((String)("captured[" + idx + "]"), (Object)actualHex, (Matcher)Matchers.is((Object)expectedHex.toUpperCase(Locale.ENGLISH)));
    }

    public List<ByteBuffer> getCaptured() {
        return this.captured;
    }

    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        ByteBuffer buf = ByteBuffer.allocate(28 + frame.getPayloadLength());
        this.generator.generateWholeFrame(frame, buf);
        BufferUtil.flipToFlush((ByteBuffer)buf, (int)0);
        this.captured.add(buf);
        if (callback != null) {
            callback.writeSuccess();
        }
    }
}

