/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.test;

import java.nio.ByteBuffer;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.LeakTrackingByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;

public class UnitGenerator
extends Generator {
    private static final Logger LOG = Log.getLogger(UnitGenerator.class);

    public static ByteBuffer generate(Frame frame) {
        return UnitGenerator.generate(new Frame[]{frame});
    }

    public static ByteBuffer generate(Frame[] frames) {
        UnitGenerator generator = new UnitGenerator();
        int buflen = 0;
        for (Frame f : frames) {
            buflen += f.getPayloadLength() + 28;
        }
        ByteBuffer completeBuf = ByteBuffer.allocate(buflen);
        BufferUtil.clearToFill((ByteBuffer)completeBuf);
        for (Frame f : frames) {
            generator.generateWholeFrame(f, completeBuf);
        }
        BufferUtil.flipToFlush((ByteBuffer)completeBuf, (int)0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("generate({} frames) - {}", new Object[]{frames.length, BufferUtil.toDetailString((ByteBuffer)completeBuf)});
        }
        return completeBuf;
    }

    public static ByteBuffer generate(List<WebSocketFrame> frames) {
        byte[] MASK = new byte[]{17, 34, 51, 68};
        UnitGenerator generator = new UnitGenerator();
        int buflen = 0;
        for (Frame frame : frames) {
            buflen += frame.getPayloadLength() + 28;
        }
        ByteBuffer completeBuf = ByteBuffer.allocate(buflen);
        BufferUtil.clearToFill((ByteBuffer)completeBuf);
        for (WebSocketFrame f : frames) {
            f.setMask(MASK);
            BufferUtil.put((ByteBuffer)generator.generateHeaderBytes((Frame)f), (ByteBuffer)completeBuf);
            ByteBuffer window = f.getPayload();
            if (!BufferUtil.hasContent((ByteBuffer)window)) continue;
            BufferUtil.put((ByteBuffer)window, (ByteBuffer)completeBuf);
        }
        BufferUtil.flipToFlush((ByteBuffer)completeBuf, (int)0);
        if (LOG.isDebugEnabled()) {
            LOG.debug("generate({} frames) - {}", new Object[]{frames.size(), BufferUtil.toDetailString((ByteBuffer)completeBuf)});
        }
        return completeBuf;
    }

    public UnitGenerator() {
        super(WebSocketPolicy.newServerPolicy(), (ByteBufferPool)new LeakTrackingByteBufferPool((ByteBufferPool)new MappedByteBufferPool.Tagged()));
    }

    public UnitGenerator(ByteBufferPool bufferPool) {
        super(WebSocketPolicy.newServerPolicy(), bufferPool);
    }
}

