/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.util;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.common.util.Hex;
import org.eclipse.jetty.websocket.common.util.Utf8PartialBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class Utf8PartialBuilderTest {
    private ByteBuffer toByteBuffer(String hexStr) {
        return ByteBuffer.wrap(Hex.asByteArray(hexStr));
    }

    @Test
    public void testPartialUnsplitCodepoint() {
        Utf8PartialBuilder utf8 = new Utf8PartialBuilder();
        String seq1 = "Hello-\uc2b5@\uc39f\uc3a4";
        String seq2 = "\uc3bc\uc3a0\uc3a1-UTF-8!!";
        String ret1 = utf8.toPartialString(BufferUtil.toBuffer((String)seq1, (Charset)StandardCharsets.UTF_8));
        String ret2 = utf8.toPartialString(BufferUtil.toBuffer((String)seq2, (Charset)StandardCharsets.UTF_8));
        MatcherAssert.assertThat((String)"Seq1", (Object)ret1, (Matcher)Matchers.is((Object)seq1));
        MatcherAssert.assertThat((String)"Seq2", (Object)ret2, (Matcher)Matchers.is((Object)seq2));
    }

    @Test
    public void testPartialSplitCodepoint() {
        Utf8PartialBuilder utf8 = new Utf8PartialBuilder();
        String seq1 = "48656C6C6F2DEC8AB540EC8E9FEC8E";
        String seq2 = "A4EC8EBCEC8EA0EC8EA12D5554462D382121";
        String ret1 = utf8.toPartialString(this.toByteBuffer(seq1));
        String ret2 = utf8.toPartialString(this.toByteBuffer(seq2));
        MatcherAssert.assertThat((String)"Seq1", (Object)ret1, (Matcher)Matchers.is((Object)"Hello-\uc2b5@\uc39f"));
        MatcherAssert.assertThat((String)"Seq2", (Object)ret2, (Matcher)Matchers.is((Object)"\uc3a4\uc3bc\uc3a0\uc3a1-UTF-8!!"));
    }

    @Test
    public void testPartialSplitCodepointWithNoBuf() {
        Utf8PartialBuilder utf8 = new Utf8PartialBuilder();
        String seq1 = "48656C6C6F2DEC8AB540EC8E9FEC8E";
        String seq2 = "A4EC8EBCEC8EA0EC8EA12D5554462D382121";
        String ret1 = utf8.toPartialString(this.toByteBuffer(seq1));
        String ret2 = utf8.toPartialString(BufferUtil.EMPTY_BUFFER);
        String ret3 = utf8.toPartialString(this.toByteBuffer(seq2));
        MatcherAssert.assertThat((String)"Seq1", (Object)ret1, (Matcher)Matchers.is((Object)"Hello-\uc2b5@\uc39f"));
        MatcherAssert.assertThat((String)"Seq2", (Object)ret2, (Matcher)Matchers.is((Object)""));
        MatcherAssert.assertThat((String)"Seq3", (Object)ret3, (Matcher)Matchers.is((Object)"\uc3a4\uc3bc\uc3a0\uc3a1-UTF-8!!"));
    }
}

