/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.common.decoders;

import jakarta.websocket.Decoder;
import jakarta.websocket.EndpointConfig;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.websocket.jakarta.common.decoders.BooleanDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteArrayDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteBufferDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ByteDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.CharacterDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.DoubleDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.FloatDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.InputStreamDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.IntegerDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.LongDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ReaderDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.RegisteredDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.ShortDecoder;
import org.eclipse.jetty.websocket.jakarta.common.decoders.StringDecoder;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.InvalidWebSocketException;
import org.eclipse.jetty.websocket.util.ReflectUtils;

public class AvailableDecoders
implements Iterable<RegisteredDecoder> {
    private final List<RegisteredDecoder> registeredDecoders = new ArrayList<RegisteredDecoder>();
    private final EndpointConfig config;

    public AvailableDecoders(EndpointConfig config) {
        this.config = Objects.requireNonNull(config);
        this.registerAll(config.getDecoders());
        this.registerPrimitive(BooleanDecoder.class, Decoder.Text.class, Boolean.class);
        this.registerPrimitive(ByteDecoder.class, Decoder.Text.class, Byte.class);
        this.registerPrimitive(CharacterDecoder.class, Decoder.Text.class, Character.class);
        this.registerPrimitive(DoubleDecoder.class, Decoder.Text.class, Double.class);
        this.registerPrimitive(FloatDecoder.class, Decoder.Text.class, Float.class);
        this.registerPrimitive(ShortDecoder.class, Decoder.Text.class, Short.class);
        this.registerPrimitive(IntegerDecoder.class, Decoder.Text.class, Integer.class);
        this.registerPrimitive(LongDecoder.class, Decoder.Text.class, Long.class);
        this.registerPrimitive(StringDecoder.class, Decoder.Text.class, String.class);
        this.registerPrimitive(BooleanDecoder.class, Decoder.Text.class, Boolean.TYPE);
        this.registerPrimitive(ByteDecoder.class, Decoder.Text.class, Byte.TYPE);
        this.registerPrimitive(CharacterDecoder.class, Decoder.Text.class, Character.TYPE);
        this.registerPrimitive(DoubleDecoder.class, Decoder.Text.class, Double.TYPE);
        this.registerPrimitive(FloatDecoder.class, Decoder.Text.class, Float.TYPE);
        this.registerPrimitive(ShortDecoder.class, Decoder.Text.class, Short.TYPE);
        this.registerPrimitive(IntegerDecoder.class, Decoder.Text.class, Integer.TYPE);
        this.registerPrimitive(LongDecoder.class, Decoder.Text.class, Long.TYPE);
        this.registerPrimitive(ByteBufferDecoder.class, Decoder.Binary.class, ByteBuffer.class);
        this.registerPrimitive(ByteArrayDecoder.class, Decoder.Binary.class, byte[].class);
        this.registerPrimitive(ReaderDecoder.class, Decoder.TextStream.class, Reader.class);
        this.registerPrimitive(InputStreamDecoder.class, Decoder.BinaryStream.class, InputStream.class);
    }

    private void registerPrimitive(Class<? extends Decoder> decoderClass, Class<? extends Decoder> interfaceType, Class<?> type) {
        this.registeredDecoders.add(new RegisteredDecoder(decoderClass, interfaceType, type, this.config, true));
    }

    private void register(Class<? extends Decoder> decoder) {
        if (!ReflectUtils.isDefaultConstructable(decoder)) {
            throw new InvalidSignatureException("Decoder must have public, no-args constructor: " + decoder.getName());
        }
        boolean foundDecoder = false;
        if (Decoder.Binary.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.Binary.class);
            foundDecoder = true;
        }
        if (Decoder.BinaryStream.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.BinaryStream.class);
            foundDecoder = true;
        }
        if (Decoder.Text.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.Text.class);
            foundDecoder = true;
        }
        if (Decoder.TextStream.class.isAssignableFrom(decoder)) {
            this.add(decoder, Decoder.TextStream.class);
            foundDecoder = true;
        }
        if (!foundDecoder) {
            throw new InvalidSignatureException("Not a valid Decoder class: " + decoder.getName() + " implements no " + Decoder.class.getName() + " interfaces");
        }
    }

    private void registerAll(List<Class<? extends Decoder>> decoders) {
        if (decoders == null) {
            return;
        }
        decoders.forEach(this::register);
    }

    private void add(Class<? extends Decoder> decoder, Class<? extends Decoder> interfaceClass) {
        Class objectType = ReflectUtils.findGenericClassFor(decoder, interfaceClass);
        if (objectType == null) {
            String err = "Unknown Decoder Object type declared for interface " + interfaceClass.getName() + " on class " + decoder;
            throw new InvalidWebSocketException(err);
        }
        for (RegisteredDecoder registered : this.registeredDecoders) {
            if (!registered.primitive && objectType.equals(registered.objectType)) {
                if (interfaceClass.equals(Decoder.TextStream.class) || interfaceClass.equals(Decoder.BinaryStream.class)) {
                    throw new InvalidWebSocketException("Multiple decoders for objectType" + objectType);
                }
                if (!registered.interfaceType.equals(interfaceClass)) {
                    throw new InvalidWebSocketException("Multiple decoders with different interface types for objectType " + objectType);
                }
            }
            if (!registered.decoder.equals(decoder) || !registered.interfaceType.equals(interfaceClass)) continue;
            return;
        }
        this.registeredDecoders.add(new RegisteredDecoder(decoder, interfaceClass, objectType, this.config));
    }

    public RegisteredDecoder getFirstRegisteredDecoder(Class<?> type) {
        return this.registeredDecoders.stream().filter(registered -> registered.isType(type)).findFirst().orElse(null);
    }

    public List<RegisteredDecoder> getRegisteredDecoders(Class<?> returnType) {
        return this.registeredDecoders.stream().filter(registered -> registered.isType(returnType)).collect(Collectors.toList());
    }

    public List<RegisteredDecoder> getRegisteredDecoders(Class<? extends Decoder> interfaceType, Class<?> returnType) {
        return this.registeredDecoders.stream().filter(registered -> registered.interfaceType.equals(interfaceType)).filter(registered -> registered.isType(returnType)).collect(Collectors.toList());
    }

    public List<RegisteredDecoder> getTextDecoders(Class<?> returnType) {
        return this.getRegisteredDecoders(Decoder.Text.class, returnType);
    }

    public List<RegisteredDecoder> getBinaryDecoders(Class<?> returnType) {
        return this.getRegisteredDecoders(Decoder.Binary.class, returnType);
    }

    public List<RegisteredDecoder> getTextStreamDecoders(Class<?> returnType) {
        return this.getRegisteredDecoders(Decoder.TextStream.class, returnType);
    }

    public List<RegisteredDecoder> getBinaryStreamDecoders(Class<?> returnType) {
        return this.getRegisteredDecoders(Decoder.BinaryStream.class, returnType);
    }

    @Override
    public Iterator<RegisteredDecoder> iterator() {
        return this.registeredDecoders.iterator();
    }

    public Stream<RegisteredDecoder> stream() {
        return this.registeredDecoders.stream();
    }
}

