/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.log.StacklessLogging;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.Parser;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.server.examples.echo.BigEchoSocket;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class AnnotatedMaxMessageSizeTest {
    private static BlockheadClient client;
    private static Server server;
    private static ServerConnector connector;
    private static URI serverUri;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new Server();
        connector = new ServerConnector(server);
        server.addConnector((Connector)connector);
        WebSocketHandler wsHandler = new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(BigEchoSocket.class);
            }
        };
        server.setHandler((Handler)wsHandler);
        server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        serverUri = new URI(String.format("ws://%s:%d/", host, port));
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testEchoGood() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(serverUri);
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "echo");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            String msg = "this is an echo ... cho ... ho ... o";
            clientConn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame.status code", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg));
        }
    }

    @Test
    public void testEchoTooBig() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(serverUri);
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "echo");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);
             StacklessLogging ignore = new StacklessLogging(new Class[]{Parser.class});){
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofSeconds(8L), () -> {
                int size = 122880;
                byte[] buf = new byte[size];
                Arrays.fill(buf, (byte)120);
                clientConn.write(new TextFrame().setPayload(ByteBuffer.wrap(buf)));
                LinkedBlockingQueue frames = clientConn.getFrameQueue();
                WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
                MatcherAssert.assertThat((String)"Frame is close", (Object)tf.getOpCode(), (Matcher)Matchers.is((Object)8));
                CloseInfo close = new CloseInfo((Frame)tf);
                MatcherAssert.assertThat((String)"Close Code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1009));
            });
        }
    }
}

