/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.WebSocketHandler;
import org.eclipse.jetty.websocket.server.helper.EchoSocket;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BatchModeTest {
    private Server server;
    private ServerConnector connector;
    private WebSocketClient client;

    @BeforeEach
    public void prepare() throws Exception {
        this.server = new Server();
        this.connector = new ServerConnector(this.server);
        this.server.addConnector((Connector)this.connector);
        WebSocketHandler handler = new WebSocketHandler(){

            public void configure(WebSocketServletFactory factory) {
                factory.register(EchoSocket.class);
            }
        };
        this.server.setHandler((Handler)handler);
        this.client = new WebSocketClient();
        this.server.addBean((Object)this.client, true);
        this.server.start();
    }

    @AfterEach
    public void dispose() throws Exception {
        this.server.stop();
    }

    @Test
    public void testBatchModeAuto() throws Exception {
        URI uri = URI.create("ws://localhost:" + this.connector.getLocalPort());
        final CountDownLatch latch = new CountDownLatch(1);
        WebSocketAdapter adapter = new WebSocketAdapter(){

            public void onWebSocketText(String message) {
                latch.countDown();
            }
        };
        try (Session session = (Session)this.client.connect((Object)adapter, uri).get();){
            RemoteEndpoint remote = session.getRemote();
            Future future = remote.sendStringByFuture("batch_mode_on");
            future.get(1L, TimeUnit.MICROSECONDS);
            Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        }
    }
}

