/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.Decorator;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class DecoratorsTest {
    private static BlockheadClient client;
    private static SimpleServletServer server;
    private static DecoratorsCreator decoratorsCreator;

    @BeforeAll
    public static void startServer() throws Exception {
        decoratorsCreator = new DecoratorsCreator();
        server = new SimpleServletServer((HttpServlet)new DecoratorsRequestServlet(decoratorsCreator)){

            @Override
            protected void configureServletContextHandler(ServletContextHandler context) {
                context.getObjectFactory().clear();
                context.getObjectFactory().addDecorator((Decorator)new DummyUtilDecorator());
            }
        };
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testAccessRequestCookies() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("info"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame resp = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            String textMsg = resp.getPayloadAsUTF8();
            MatcherAssert.assertThat((String)"DecoratedObjectFactory", (Object)textMsg, (Matcher)Matchers.containsString((String)"Object is a DecoratedObjectFactory"));
            MatcherAssert.assertThat((String)"decorators.size", (Object)textMsg, (Matcher)Matchers.containsString((String)"Decorators.size = [1]"));
            MatcherAssert.assertThat((String)"decorator type", (Object)textMsg, (Matcher)Matchers.containsString((String)("decorator[] = " + DummyUtilDecorator.class.getName())));
        }
    }

    private static class DummyUtilDecorator
    implements Decorator {
        private DummyUtilDecorator() {
        }

        public <T> T decorate(T o) {
            return o;
        }

        public void destroy(Object o) {
        }
    }

    public static class DecoratorsRequestServlet
    extends WebSocketServlet {
        private static final long serialVersionUID = 1L;
        private final WebSocketCreator creator;

        public DecoratorsRequestServlet(WebSocketCreator creator) {
            this.creator = creator;
        }

        public void configure(WebSocketServletFactory factory) {
            factory.setCreator(this.creator);
        }
    }

    private static class DecoratorsCreator
    implements WebSocketCreator {
        private DecoratorsCreator() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            ServletContext servletContext = req.getHttpServletRequest().getServletContext();
            DecoratedObjectFactory objFactory = (DecoratedObjectFactory)servletContext.getAttribute(DecoratedObjectFactory.ATTR);
            return new DecoratorsSocket(objFactory);
        }
    }

    private static class DecoratorsSocket
    extends WebSocketAdapter {
        private final DecoratedObjectFactory objFactory;

        public DecoratorsSocket(DecoratedObjectFactory objFactory) {
            this.objFactory = objFactory;
        }

        public void onWebSocketText(String message) {
            StringWriter str = new StringWriter();
            PrintWriter out = new PrintWriter(str);
            if (this.objFactory != null) {
                out.printf("Object is a DecoratedObjectFactory%n", new Object[0]);
                List decorators = this.objFactory.getDecorators();
                out.printf("Decorators.size = [%d]%n", decorators.size());
                for (Decorator decorator : decorators) {
                    out.printf(" decorator[] = %s%n", decorator.getClass().getName());
                }
            } else {
                out.printf("DecoratedObjectFactory is NULL%n", new Object[0]);
            }
            this.getRemote().sendStringByFuture(str.toString());
        }
    }
}

