/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.examples.MyEchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FirefoxTest {
    private static BlockheadClient client;
    private static SimpleServletServer server;

    @BeforeAll
    public static void startContainers() throws Exception {
        server = new SimpleServletServer((HttpServlet)new MyEchoServlet());
        server.start();
        client = new BlockheadClient();
        client.start();
    }

    @AfterAll
    public static void stopContainers() throws Exception {
        client.stop();
        server.stop();
    }

    @Test
    public void testConnectionKeepAlive() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.CONNECTION, "keep-alive, Upgrade");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection conn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            String msg = "this is an echo ... cho ... ho ... o";
            conn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            LinkedBlockingQueue frames = conn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame.status code", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg));
        }
    }
}

