/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.EchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class FragmentExtensionTest {
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new EchoServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    private String[] split(String str, int partSize) {
        int strLength = str.length();
        int count = (int)Math.ceil((double)str.length() / (double)partSize);
        String[] ret = new String[count];
        for (int i = 0; i < count; ++i) {
            int idx = i * partSize;
            ret[i] = str.substring(idx, Math.min(idx + partSize, strLength));
        }
        return ret;
    }

    @Test
    public void testFragmentExtension() throws Exception {
        Assumptions.assumeTrue((boolean)server.getWebSocketServletFactory().getExtensionFactory().isAvailable("fragment"), (String)"Server has fragment registered");
        Assumptions.assumeTrue((boolean)client.getExtensionFactory().isAvailable("fragment"), (String)"Client has fragment registered");
        int fragSize = 4;
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, "fragment;maxLength=" + fragSize);
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "onConnect");
        request.idleTimeout(1L, TimeUnit.SECONDS);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            HttpFields responseHeaders = clientConn.getUpgradeResponseHeaders();
            HttpField extensionHeader = responseHeaders.getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
            MatcherAssert.assertThat((String)"Response", (Object)extensionHeader.getValue(), (Matcher)Matchers.containsString((String)"fragment"));
            String msg = "Sent as a long message that should be split";
            clientConn.write((WebSocketFrame)new TextFrame().setPayload(msg));
            String[] parts = this.split(msg, fragSize);
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            for (int i = 0; i < parts.length; ++i) {
                WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
                MatcherAssert.assertThat((String)("text[" + i + "].payload"), (Object)frame.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)parts[i]));
            }
        }
    }
}

