/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.EchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class IdentityExtensionTest {
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new EchoServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testIdentityExtension() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, "identity;param=0");
        request.header(HttpHeader.SEC_WEBSOCKET_EXTENSIONS, "identity;param=1, identity ; param = '2' ; other = ' some = value '");
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "onConnect");
        request.idleTimeout(1L, TimeUnit.SECONDS);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            HttpFields responseHeaders = clientConn.getUpgradeResponseHeaders();
            HttpField extensionHeader = responseHeaders.getField(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
            MatcherAssert.assertThat((String)"Response", (Object)extensionHeader.getValue(), (Matcher)Matchers.containsString((String)"identity"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("Hello"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"TEXT.payload", (Object)frame.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"Hello"));
        }
    }
}

