/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.RFCSocket;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class IdleTimeoutTest {
    public static final int IDLE_TIMEOUT_MS_WEBSOCKET_SERVER = 500;
    public static final int IDLE_TIMEOUT_ON_SERVER = 1000;
    public static final int IDLE_TIMEOUT_MS_WEBSOCKET_CLIENT = 2500;
    private static BlockheadClient client;
    private static SimpleServletServer server;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new TimeoutServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testIdleTimeout() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, "onConnect");
        request.idleTimeout(2500L, TimeUnit.MILLISECONDS);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            TimeUnit.MILLISECONDS.sleep(1000L);
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("Hello"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame frame = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"frame opcode", (Object)frame.getOpCode(), (Matcher)Matchers.is((Object)8));
            CloseInfo close = new CloseInfo((Frame)frame);
            MatcherAssert.assertThat((String)"close code", (Object)close.getStatusCode(), (Matcher)Matchers.is((Object)1001));
            MatcherAssert.assertThat((String)"close reason", (Object)close.getReason(), (Matcher)Matchers.containsString((String)"timeout"));
        }
    }

    public static class TimeoutServlet
    extends WebSocketServlet {
        public void configure(WebSocketServletFactory factory) {
            factory.getPolicy().setIdleTimeout(500L);
            factory.register(RFCSocket.class);
        }
    }
}

