/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.common.util.Sha1Sum;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.CaptureSocket;
import org.eclipse.jetty.websocket.server.helper.EchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class PerMessageDeflateExtensionTest {
    private SimpleServletServer server;

    public static Stream<Arguments> modes() {
        ArrayList<Scenario> modes = new ArrayList<Scenario>();
        for (Sizes size : Sizes.values()) {
            modes.add(new Scenario("Normal HTTP/WS", false, "ws", size, -1));
            modes.add(new Scenario("Encrypted HTTPS/WSS", true, "wss", size, -1));
            int altInputBufSize = 15360;
            modes.add(new Scenario("Normal HTTP/WS", false, "ws", size, altInputBufSize));
            modes.add(new Scenario("Encrypted HTTPS/WSS", true, "wss", size, altInputBufSize));
        }
        return modes.stream().map(xva$0 -> Arguments.of((Object[])new Object[]{xva$0}));
    }

    private void startServer(Scenario scenario) throws Exception {
        this.server = new SimpleServletServer((HttpServlet)new EchoServlet());
        this.server.enableSsl(scenario.sslMode);
        this.server.start();
    }

    @AfterEach
    public void stopServer() {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"modes"})
    public void testPerMessageDeflateDefault(Scenario scenario) throws Exception {
        this.startServer(scenario);
        Assumptions.assumeTrue((boolean)this.server.getWebSocketServletFactory().getExtensionFactory().isAvailable("permessage-deflate"), (String)"Server has permessage-deflate registered");
        MatcherAssert.assertThat((String)"server scheme", (Object)this.server.getServerUri().getScheme(), (Matcher)Matchers.is((Object)scenario.scheme));
        int binBufferSize = (int)((double)scenario.msgSize.size * 1.5);
        WebSocketPolicy serverPolicy = this.server.getWebSocketServletFactory().getPolicy();
        binBufferSize = Math.max(binBufferSize, serverPolicy.getMaxBinaryMessageSize());
        binBufferSize = Math.max(binBufferSize, serverPolicy.getMaxBinaryMessageBufferSize());
        binBufferSize = Math.max(binBufferSize, scenario.inputBufferSize);
        serverPolicy.setMaxBinaryMessageSize(binBufferSize);
        serverPolicy.setMaxBinaryMessageBufferSize(binBufferSize);
        WebSocketClient client = new WebSocketClient(this.server.getSslContextFactory());
        WebSocketPolicy clientPolicy = client.getPolicy();
        clientPolicy.setMaxBinaryMessageSize(binBufferSize);
        clientPolicy.setMaxBinaryMessageBufferSize(binBufferSize);
        if (scenario.inputBufferSize > 0) {
            clientPolicy.setInputBufferSize(scenario.inputBufferSize);
        }
        try {
            client.start();
            client.setMaxIdleTimeout(TimeUnit.SECONDS.toMillis(15L));
            CaptureSocket clientSocket = new CaptureSocket();
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            request.addExtensions(new String[]{"permessage-deflate"});
            request.setSubProtocols(new String[]{"echo"});
            Future fut = client.connect((Object)clientSocket, this.server.getServerUri(), request);
            Session session = (Session)fut.get(30L, TimeUnit.SECONDS);
            MatcherAssert.assertThat((String)"Response.extensions", (Object)this.getNegotiatedExtensionList(session), (Matcher)Matchers.containsString((String)"permessage-deflate"));
            byte[] msg = new byte[scenario.msgSize.size];
            Random rand = new Random();
            rand.setSeed(8080L);
            rand.nextBytes(msg);
            String sha1 = Sha1Sum.calculate((byte[])msg);
            session.getRemote().sendBytes(ByteBuffer.wrap(msg));
            String echoMsg = clientSocket.messages.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Echo'd Message", (Object)echoMsg, (Matcher)Matchers.is((Object)("binary[sha1=" + sha1 + "]")));
        }
        finally {
            client.stop();
        }
    }

    private String getNegotiatedExtensionList(Session session) {
        StringBuilder actual = new StringBuilder();
        actual.append('[');
        boolean delim = false;
        for (ExtensionConfig ext : session.getUpgradeResponse().getExtensions()) {
            if (delim) {
                actual.append(", ");
            }
            actual.append(ext.getName());
            delim = true;
        }
        actual.append(']');
        return actual.toString();
    }

    public static class Scenario {
        public final String mode;
        public final boolean sslMode;
        public final String scheme;
        public final Sizes msgSize;
        public final int inputBufferSize;

        public Scenario(String mode, boolean sslMode, String scheme, Sizes msgSize, int bufferSize) {
            this.mode = mode;
            this.sslMode = sslMode;
            this.scheme = scheme;
            this.msgSize = msgSize;
            this.inputBufferSize = bufferSize;
        }

        public String toString() {
            return String.format("%s (%s) (Input Buffer Size: %,d bytes)", this.mode, this.scheme, this.msgSize.size);
        }
    }

    public static enum Sizes {
        TINY(10),
        SMALL(1024),
        MEDIUM(10240),
        LARGE(102400),
        HUGE(0x100000);

        private int size;

        private Sizes(int size) {
            this.size = size;
        }
    }
}

