/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import java.util.concurrent.Future;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.SecuredRedirectHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.server.helper.EchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RedirectWebSocketClientTest {
    public static Server server;
    public static URI serverWsUri;
    public static URI serverWssUri;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new Server();
        HttpConfiguration http_config = new HttpConfiguration();
        http_config.setSecureScheme("https");
        http_config.setSecurePort(0);
        http_config.setOutputBufferSize(32768);
        http_config.setRequestHeaderSize(8192);
        http_config.setResponseHeaderSize(8192);
        http_config.setSendServerVersion(true);
        http_config.setSendDateHeader(false);
        SslContextFactory sslContextFactory = RedirectWebSocketClientTest.newSslContextFactory();
        HttpConfiguration https_config = new HttpConfiguration(http_config);
        https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        ServerConnector sslConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
        sslConnector.setPort(0);
        server.addConnector((Connector)sslConnector);
        ServerConnector connector = new ServerConnector(server);
        connector.setPort(0);
        server.addConnector((Connector)connector);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setContextPath("/");
        contextHandler.addServlet(EchoServlet.class, "/echo");
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)new SecuredRedirectHandler());
        handlers.addHandler((Handler)contextHandler);
        handlers.addHandler((Handler)new DefaultHandler());
        server.setHandler((Handler)handlers);
        server.start();
        serverWsUri = URI.create("ws://localhost:" + connector.getLocalPort() + "/");
        serverWssUri = URI.create("wss://localhost:" + sslConnector.getLocalPort() + "/");
        HttpConnectionFactory connectionFactory = (HttpConnectionFactory)connector.getConnectionFactory(HttpConnectionFactory.class);
        connectionFactory.getHttpConfiguration().setSecurePort(sslConnector.getLocalPort());
    }

    @AfterAll
    public static void stopServer() throws Exception {
        server.stop();
    }

    private static SslContextFactory newSslContextFactory() {
        SslContextFactory ssl = new SslContextFactory();
        ssl.setKeyStorePath(MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath());
        ssl.setKeyStorePassword("storepwd");
        ssl.setKeyManagerPassword("keypwd");
        return ssl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRedirect() throws Exception {
        SslContextFactory ssl = RedirectWebSocketClientTest.newSslContextFactory();
        ssl.setTrustAll(false);
        ssl.setEndpointIdentificationAlgorithm(null);
        HttpClient httpClient = new HttpClient(ssl);
        WebSocketClient client = new WebSocketClient(httpClient);
        client.addBean((Object)httpClient, true);
        client.start();
        try {
            URI wsUri = serverWsUri.resolve("/echo");
            ClientUpgradeRequest request = new ClientUpgradeRequest();
            Future sessionFuture = client.connect((Object)new EmptyWebSocket(), wsUri, request);
            Session session = (Session)sessionFuture.get();
            MatcherAssert.assertThat((Object)session, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        finally {
            client.stop();
        }
    }

    @WebSocket
    public static class EmptyWebSocket {
    }
}

