/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.HttpCookie;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.EchoSocket;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class RequestHeadersTest {
    private static BlockheadClient client;
    private static SimpleServletServer server;
    private static EchoCreator echoCreator;

    @BeforeAll
    public static void startServer() throws Exception {
        echoCreator = new EchoCreator();
        server = new SimpleServletServer((HttpServlet)new EchoRequestServlet(echoCreator));
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testAccessRequestCookies() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.idleTimeout(1L, TimeUnit.SECONDS);
        request.header(HttpHeader.COOKIE, "fruit=Pear; type=Anjou");
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection ignore = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            UpgradeRequest req = echoCreator.getLastRequest();
            MatcherAssert.assertThat((String)"Last Request", (Object)req, (Matcher)Matchers.notNullValue());
            List cookies = req.getCookies();
            MatcherAssert.assertThat((String)"Request cookies", (Object)cookies, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"Request cookies.size", (Object)cookies.size(), (Matcher)Matchers.is((Object)2));
            for (HttpCookie cookie : cookies) {
                MatcherAssert.assertThat((String)"Cookie name", (Object)cookie.getName(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"fruit"), (Matcher)Matchers.is((Object)"type")));
                MatcherAssert.assertThat((String)"Cookie value", (Object)cookie.getValue(), (Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)"Pear"), (Matcher)Matchers.is((Object)"Anjou")));
            }
        }
    }

    @Test
    public void testRequestURI() throws Exception {
        URI destUri = server.getServerUri().resolve("/?abc=x%20z&breakfast=bacon%26eggs&2*2%3d5=false");
        BlockheadClientRequest request = client.newWsRequest(destUri);
        request.idleTimeout(1L, TimeUnit.SECONDS);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection ignore = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            UpgradeRequest req = echoCreator.getLastRequest();
            MatcherAssert.assertThat((String)"Last Request", (Object)req, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((String)"Request.host", (Object)req.getHost(), (Matcher)Matchers.is((Object)server.getServerUri().getHost()));
            MatcherAssert.assertThat((String)"Request.queryString", (Object)req.getQueryString(), (Matcher)Matchers.is((Object)"abc=x%20z&breakfast=bacon%26eggs&2*2%3d5=false"));
            MatcherAssert.assertThat((String)"Request.uri.path", (Object)req.getRequestURI().getPath(), (Matcher)Matchers.is((Object)"/"));
            MatcherAssert.assertThat((String)"Request.uri.rawQuery", (Object)req.getRequestURI().getRawQuery(), (Matcher)Matchers.is((Object)"abc=x%20z&breakfast=bacon%26eggs&2*2%3d5=false"));
            MatcherAssert.assertThat((String)"Request.uri.query", (Object)req.getRequestURI().getQuery(), (Matcher)Matchers.is((Object)"abc=x z&breakfast=bacon&eggs&2*2=5=false"));
        }
    }

    public static class EchoRequestServlet
    extends WebSocketServlet {
        private static final long serialVersionUID = -6575001979901924179L;
        private final WebSocketCreator creator;

        public EchoRequestServlet(WebSocketCreator creator) {
            this.creator = creator;
        }

        public void configure(WebSocketServletFactory factory) {
            factory.setCreator(this.creator);
        }
    }

    private static class EchoCreator
    implements WebSocketCreator {
        private UpgradeRequest lastRequest;
        private UpgradeResponse lastResponse;
        private EchoSocket echoSocket = new EchoSocket();

        private EchoCreator() {
        }

        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            this.lastRequest = req;
            this.lastResponse = resp;
            return this.echoSocket;
        }

        public UpgradeRequest getLastRequest() {
            return this.lastRequest;
        }

        public UpgradeResponse getLastResponse() {
            return this.lastResponse;
        }
    }
}

