/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.server.WebSocketUpgradeFilter;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;

public class SimpleServletServer {
    private static final Logger LOG = Log.getLogger(SimpleServletServer.class);
    private Server server;
    private ServerConnector connector;
    private URI serverUri;
    private HttpServlet servlet;
    private boolean ssl = false;
    private SslContextFactory sslContextFactory;

    public SimpleServletServer(HttpServlet servlet) {
        this.servlet = servlet;
    }

    public void enableSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public URI getServerUri() {
        return this.serverUri;
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    public boolean isSslEnabled() {
        return this.ssl;
    }

    public void start() throws Exception {
        this.server = new Server();
        if (this.ssl) {
            HttpConfiguration http_config = new HttpConfiguration();
            http_config.setSecureScheme("https");
            http_config.setSecurePort(0);
            http_config.setOutputBufferSize(32768);
            http_config.setRequestHeaderSize(8192);
            http_config.setResponseHeaderSize(8192);
            http_config.setSendServerVersion(true);
            http_config.setSendDateHeader(false);
            this.sslContextFactory = new SslContextFactory();
            this.sslContextFactory.setKeyStorePath(MavenTestingUtils.getTestResourceFile((String)"keystore").getAbsolutePath());
            this.sslContextFactory.setKeyStorePassword("storepwd");
            this.sslContextFactory.setKeyManagerPassword("keypwd");
            this.sslContextFactory.setEndpointIdentificationAlgorithm(null);
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            this.connector = new ServerConnector(this.server, new ConnectionFactory[]{new SslConnectionFactory(this.sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(https_config)});
            this.connector.setPort(0);
        } else {
            this.connector = new ServerConnector(this.server);
            this.connector.setPort(0);
        }
        this.server.addConnector((Connector)this.connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.configureServletContextHandler(context);
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)this.servlet), "/*");
        this.server.start();
        String host = this.connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = this.connector.getLocalPort();
        this.serverUri = new URI(String.format("%s://%s:%d/", this.ssl ? "wss" : "ws", host, port));
        if (LOG.isDebugEnabled()) {
            LOG.debug(this.server.dump(), new Object[0]);
        }
    }

    protected void configureServletContextHandler(ServletContextHandler context) {
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public WebSocketServletFactory getWebSocketServletFactory() {
        WebSocketUpgradeFilter filter = (WebSocketUpgradeFilter)this.servlet.getServletContext().getAttribute(WebSocketUpgradeFilter.class.getName());
        if (filter != null) {
            return filter.getFactory();
        }
        return (WebSocketServletFactory)this.servlet.getServletContext().getAttribute(WebSocketServletFactory.class.getName());
    }
}

