/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SubProtocolTest {
    private static BlockheadClient client;
    private static SimpleServletServer server;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new ProtocolServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testSingleProtocol() throws Exception {
        this.testSubProtocol("echo", "echo");
    }

    @Test
    public void testMultipleProtocols() throws Exception {
        this.testSubProtocol("chat,info,echo", "chat");
    }

    private void testSubProtocol(String requestProtocols, String acceptedSubProtocols) throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL, requestProtocols);
        request.idleTimeout(1L, TimeUnit.SECONDS);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("showme"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)(ProtocolEchoSocket.class.getSimpleName() + ".onMessage()"), (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)("acceptedSubprotocol=" + acceptedSubProtocols)));
        }
    }

    public static class ProtocolServlet
    extends WebSocketServlet {
        public void configure(WebSocketServletFactory factory) {
            factory.setCreator((WebSocketCreator)new ProtocolCreator());
        }
    }

    public static class ProtocolCreator
    implements WebSocketCreator {
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            if (req.getSubProtocols() != null && !req.getSubProtocols().isEmpty()) {
                String subProtocol = (String)req.getSubProtocols().get(0);
                resp.setAcceptedSubProtocol(subProtocol);
            }
            return new ProtocolEchoSocket();
        }
    }

    @WebSocket
    public static class ProtocolEchoSocket {
        private Session session;
        private String acceptedProtocol;

        @OnWebSocketConnect
        public void onConnect(Session session) {
            this.session = session;
            this.acceptedProtocol = session.getUpgradeResponse().getAcceptedSubProtocol();
        }

        @OnWebSocketMessage
        public void onMsg(String msg) {
            this.session.getRemote().sendStringByFuture("acceptedSubprotocol=" + this.acceptedProtocol);
        }
    }
}

