/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeRequest;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class SuspendResumeTest {
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new EchoServlet());
        server.start();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @Test
    public void testSuspendResume() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("echo1"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("echo2"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)(EchoSocket.class.getSimpleName() + ".onMessage()"), (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"echo1"));
            tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)(EchoSocket.class.getSimpleName() + ".onMessage()"), (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"echo2"));
        }
    }

    public static class EchoServlet
    extends WebSocketServlet {
        private static final long serialVersionUID = 1L;

        public void configure(WebSocketServletFactory factory) {
            factory.setCreator((WebSocketCreator)new EchoCreator());
        }
    }

    public static class EchoCreator
    implements WebSocketCreator {
        public Object createWebSocket(ServletUpgradeRequest req, ServletUpgradeResponse resp) {
            return new EchoSocket();
        }
    }

    @WebSocket
    public static class EchoSocket {
        private Session session;

        @OnWebSocketConnect
        public void onConnect(Session session) {
            this.session = session;
        }

        @OnWebSocketMessage
        public void onMessage(String message) {
            final SuspendToken suspendToken = this.session.suspend();
            this.session.getRemote().sendString(message, new WriteCallback(){

                public void writeSuccess() {
                    suspendToken.resume();
                }

                public void writeFailed(Throwable t) {
                    Assertions.fail((Throwable)t);
                }
            });
        }
    }
}

