/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.Generator;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.examples.MyEchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TooFastClientTest {
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new MyEchoServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    private ByteBuffer createInitialPacket(String ... msgs) {
        int len = Arrays.stream(msgs).mapToInt(str -> str.length() + 28).sum();
        ByteBuffer initialPacket = ByteBuffer.allocate(len);
        BufferUtil.clearToFill((ByteBuffer)initialPacket);
        Generator generator = new Generator(WebSocketPolicy.newClientPolicy(), (ByteBufferPool)new MappedByteBufferPool());
        for (String msg : msgs) {
            TextFrame frame = new TextFrame().setPayload(msg);
            byte[] mask = new byte[]{17, 34, 51, 68};
            frame.setMask(mask);
            generator.generateWholeFrame((Frame)frame, initialPacket);
        }
        BufferUtil.flipToFlush((ByteBuffer)initialPacket, (int)0);
        return initialPacket;
    }

    @Test
    public void testUpgradeWithSmallFrames() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        String msg1 = "Echo 1";
        String msg2 = "This is also an echooooo!";
        ByteBuffer initialPacket = this.createInitialPacket(msg1, msg2);
        request.setInitialBytes(initialPacket);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame/msg1", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg1));
            tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame/msg2", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)msg2));
        }
    }

    @Test
    public void testUpgradeWithLargeFrame() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        byte[] bigMsgBytes = new byte[65536];
        Arrays.fill(bigMsgBytes, (byte)120);
        String bigMsg = new String(bigMsgBytes, StandardCharsets.UTF_8);
        ByteBuffer initialPacket = this.createInitialPacket(bigMsg);
        request.setInitialBytes(initialPacket);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Text Frame/msg1", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)bigMsg));
        }
    }
}

