/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.jetty.annotations.AnnotationConfiguration;
import org.eclipse.jetty.plus.webapp.EnvConfiguration;
import org.eclipse.jetty.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.toolchain.test.FS;
import org.eclipse.jetty.toolchain.test.IO;
import org.eclipse.jetty.toolchain.test.JAR;
import org.eclipse.jetty.toolchain.test.MavenTestingUtils;
import org.eclipse.jetty.toolchain.test.jupiter.WorkDir;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.FragmentConfiguration;
import org.eclipse.jetty.webapp.MetaInfConfiguration;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebInfConfiguration;
import org.eclipse.jetty.webapp.WebXmlConfiguration;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;

public class WSServer {
    private static final Logger LOG = Log.getLogger(WSServer.class);
    private final File contextDir;
    private final String contextPath;
    private Server server;
    private URI serverUri;
    private ContextHandlerCollection contexts;
    private File webinf;
    private File classesDir;

    public WSServer(WorkDir testdir, String contextName) {
        this(testdir.getPath().toFile(), contextName);
    }

    public WSServer(File testdir, String contextName) {
        this.contextDir = new File(testdir, contextName);
        this.contextPath = "/" + contextName;
        FS.ensureEmpty((File)this.contextDir);
    }

    public void copyClass(Class<?> clazz) throws Exception {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String endpointPath = clazz.getName().replace('.', '/') + ".class";
        URL classUrl = cl.getResource(endpointPath);
        MatcherAssert.assertThat((String)("Class URL for: " + clazz), (Object)classUrl, (Matcher)Matchers.notNullValue());
        File destFile = new File(this.classesDir, FS.separators((String)endpointPath));
        FS.ensureDirExists((File)destFile.getParentFile());
        File srcFile = new File(classUrl.toURI());
        IO.copy((File)srcFile, (File)destFile);
    }

    public void copyEndpoint(Class<?> endpointClass) throws Exception {
        this.copyClass(endpointClass);
    }

    public void copyLib(Class<?> clazz, String jarFileName) throws URISyntaxException, IOException {
        this.webinf = new File(this.contextDir, "WEB-INF");
        FS.ensureDirExists((File)this.webinf);
        File libDir = new File(this.webinf, "lib");
        FS.ensureDirExists((File)libDir);
        File jarFile = new File(libDir, jarFileName);
        URL codeSourceURL = clazz.getProtectionDomain().getCodeSource().getLocation();
        MatcherAssert.assertThat((String)"Class CodeSource URL is file scheme", (Object)codeSourceURL.getProtocol(), (Matcher)CoreMatchers.is((Object)"file"));
        File sourceCodeSourceFile = new File(codeSourceURL.toURI());
        if (sourceCodeSourceFile.isDirectory()) {
            LOG.info("Creating " + jarFile + " from " + sourceCodeSourceFile, new Object[0]);
            JAR.create((File)sourceCodeSourceFile, (File)jarFile);
        } else {
            LOG.info("Copying " + sourceCodeSourceFile + " to " + jarFile, new Object[0]);
            IO.copy((File)sourceCodeSourceFile, (File)jarFile);
        }
    }

    public void copyWebInf(String testResourceName) throws IOException {
        this.webinf = new File(this.contextDir, "WEB-INF");
        FS.ensureDirExists((File)this.webinf);
        this.classesDir = new File(this.webinf, "classes");
        FS.ensureDirExists((File)this.classesDir);
        File webxml = new File(this.webinf, "web.xml");
        File testWebXml = MavenTestingUtils.getTestResourceFile((String)testResourceName);
        IO.copy((File)testWebXml, (File)webxml);
    }

    public WebAppContext createWebAppContext() throws MalformedURLException, IOException {
        WebAppContext context = new WebAppContext();
        context.setContextPath(this.contextPath);
        context.setBaseResource(Resource.newResource((File)this.contextDir));
        context.setAttribute("org.eclipse.jetty.websocket.jsr356", (Object)Boolean.TRUE);
        context.setConfigurations(new Configuration[]{new AnnotationConfiguration(), new WebXmlConfiguration(), new WebInfConfiguration(), new PlusConfiguration(), new MetaInfConfiguration(), new FragmentConfiguration(), new EnvConfiguration()});
        return context;
    }

    public void createWebInf() throws IOException {
        this.copyWebInf("empty-web.xml");
    }

    public void deployWebapp(WebAppContext webapp) throws Exception {
        this.contexts.addHandler((Handler)webapp);
        this.contexts.manage((Object)webapp);
        webapp.start();
        if (LOG.isDebugEnabled()) {
            webapp.dump((Appendable)System.err);
        }
    }

    public void dump() {
        this.server.dumpStdErr();
    }

    public URI getServerBaseURI() {
        return this.serverUri;
    }

    public Server getServer() {
        return this.server;
    }

    public File getWebAppDir() {
        return this.contextDir;
    }

    public void start() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        this.contexts = new ContextHandlerCollection();
        handlers.addHandler((Handler)this.contexts);
        this.server.setHandler((Handler)handlers);
        this.server.start();
        String host = connector.getHost();
        if (host == null) {
            host = "localhost";
        }
        int port = connector.getLocalPort();
        this.serverUri = new URI(String.format("ws://%s:%d%s/", host, port, this.contextPath));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Server started on {}", new Object[]{this.serverUri});
        }
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

