/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.UpgradeException;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.examples.MyEchoServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class WebSocketInvalidVersionTest {
    private static BlockheadClient client;
    private static SimpleServletServer server;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new MyEchoServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testRequestVersion29() throws Exception {
        BlockheadClientRequest request = client.newWsRequest(server.getServerUri());
        request.header(HttpHeader.SEC_WEBSOCKET_VERSION, "29");
        CompletableFuture connFut = request.sendAsync();
        ExecutionException x = (ExecutionException)Assertions.assertThrows(ExecutionException.class, () -> connFut.get(2L, Timeouts.CONNECT_UNIT));
        MatcherAssert.assertThat((Object)x.getCause(), (Matcher)Matchers.instanceOf(UpgradeException.class));
        MatcherAssert.assertThat((Object)x.getMessage(), (Matcher)Matchers.containsString((String)"400 Unsupported websocket version specification"));
    }
}

