/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.websocket.api.BatchMode;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.CaptureSocket;
import org.eclipse.jetty.websocket.server.helper.SessionServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class WebSocketOverSSLTest {
    public static final int CONNECT_TIMEOUT = 15000;
    public static final int FUTURE_TIMEOUT_SEC = 30;
    public ByteBufferPool bufferPool = new MappedByteBufferPool();
    private static SimpleServletServer server;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new SessionServlet());
        server.enableSsl(true);
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEcho() throws Exception {
        MatcherAssert.assertThat((String)"server scheme", (Object)server.getServerUri().getScheme(), (Matcher)Matchers.is((Object)"wss"));
        WebSocketClient client = new WebSocketClient(server.getSslContextFactory(), null, this.bufferPool);
        try {
            client.start();
            CaptureSocket clientSocket = new CaptureSocket();
            URI requestUri = server.getServerUri();
            System.err.printf("Request URI: %s%n", requestUri.toASCIIString());
            Future fut = client.connect((Object)clientSocket, requestUri);
            Session session = (Session)fut.get(30L, TimeUnit.SECONDS);
            String msg = "this is an echo ... cho ... ho ... o";
            RemoteEndpoint remote = session.getRemote();
            remote.sendString(msg);
            if (remote.getBatchMode() == BatchMode.ON) {
                remote.flush();
            }
            LinkedBlockingQueue<String> captured = clientSocket.messages;
            MatcherAssert.assertThat((String)"Text Message", (Object)captured.poll(2L, Timeouts.POLL_EVENT_UNIT), (Matcher)Matchers.is((Object)msg));
            clientSocket.close();
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSessionIsSecure() throws Exception {
        MatcherAssert.assertThat((String)"server scheme", (Object)server.getServerUri().getScheme(), (Matcher)Matchers.is((Object)"wss"));
        WebSocketClient client = new WebSocketClient(server.getSslContextFactory(), null, this.bufferPool);
        try {
            client.setConnectTimeout(15000L);
            client.start();
            CaptureSocket clientSocket = new CaptureSocket();
            URI requestUri = server.getServerUri();
            System.err.printf("Request URI: %s%n", requestUri.toASCIIString());
            Future fut = client.connect((Object)clientSocket, requestUri);
            Session session = (Session)fut.get(30L, TimeUnit.SECONDS);
            RemoteEndpoint remote = session.getRemote();
            remote.sendString("session.isSecure");
            if (remote.getBatchMode() == BatchMode.ON) {
                remote.flush();
            }
            LinkedBlockingQueue<String> captured = clientSocket.messages;
            MatcherAssert.assertThat((String)"Server.session.isSecure", (Object)captured.poll(2L, Timeouts.POLL_EVENT_UNIT), (Matcher)Matchers.is((Object)"session.isSecure=true"));
            clientSocket.close();
        }
        finally {
            client.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerSessionRequestURI() throws Exception {
        MatcherAssert.assertThat((String)"server scheme", (Object)server.getServerUri().getScheme(), (Matcher)Matchers.is((Object)"wss"));
        WebSocketClient client = new WebSocketClient(server.getSslContextFactory(), null, this.bufferPool);
        try {
            client.setConnectTimeout(15000L);
            client.start();
            CaptureSocket clientSocket = new CaptureSocket();
            URI requestUri = server.getServerUri().resolve("/deep?a=b");
            System.err.printf("Request URI: %s%n", requestUri.toASCIIString());
            Future fut = client.connect((Object)clientSocket, requestUri);
            Session session = (Session)fut.get(30L, TimeUnit.SECONDS);
            RemoteEndpoint remote = session.getRemote();
            remote.sendString("session.upgradeRequest.requestURI");
            if (remote.getBatchMode() == BatchMode.ON) {
                remote.flush();
            }
            LinkedBlockingQueue<String> captured = clientSocket.messages;
            String expected = String.format("session.upgradeRequest.requestURI=%s", requestUri.toASCIIString());
            MatcherAssert.assertThat((String)"session.upgradeRequest.requestURI", (Object)captured.poll(2L, Timeouts.POLL_EVENT_UNIT), (Matcher)Matchers.is((Object)expected));
            clientSocket.close();
        }
        finally {
            client.stop();
        }
    }
}

