/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import javax.servlet.Servlet;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.websocket.server.helper.EchoSocket;
import org.eclipse.jetty.websocket.servlet.WebSocketServlet;
import org.eclipse.jetty.websocket.servlet.WebSocketServletFactory;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WebSocketProtocolTest {
    private Server server;

    @BeforeEach
    public void startServer() throws Exception {
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        ServletHolder holder = new ServletHolder((Servlet)new WebSocketServlet(){

            public void configure(WebSocketServletFactory factory) {
                factory.getPolicy().setIdleTimeout(10000L);
                factory.getPolicy().setMaxTextMessageSize(0x200000);
                factory.setCreator((req, resp) -> {
                    if (req.hasSubProtocol("echo")) {
                        resp.setAcceptedSubProtocol("echo");
                    }
                    return new EchoSocket();
                });
            }
        });
        context.addServlet(holder, "/ws");
        HandlerList handlers = new HandlerList();
        handlers.addHandler((Handler)context);
        handlers.addHandler((Handler)new DefaultHandler());
        this.server.setHandler((Handler)handlers);
        this.server.start();
    }

    @AfterEach
    public void stopServer() throws Exception {
        this.server.stop();
    }

    @Test
    public void testWebSocketProtocolResponse() throws Exception {
        URI uri = this.server.getURI();
        String host = uri.getHost();
        int port = uri.getPort();
        try (Socket client = new Socket(host, port);){
            byte[] key = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
            StringBuilder request = new StringBuilder();
            request.append("GET /ws HTTP/1.1\r\n").append("Host: localhost\r\n").append("Connection: Upgrade\r\n").append("Upgrade: websocket\r\n").append("Sec-WebSocket-version: 13\r\n").append("Sec-WebSocket-Key:").append(B64Code.encode((byte[])key)).append("\r\n").append("Sec-WebSocket-Protocol: echo\r\n").append("\r\n");
            OutputStream output = client.getOutputStream();
            output.write(request.toString().getBytes(StandardCharsets.UTF_8));
            output.flush();
            BufferedReader input = new BufferedReader(new InputStreamReader(client.getInputStream()));
            String line = input.readLine();
            MatcherAssert.assertThat((Object)line, (Matcher)Matchers.containsString((String)" 101 "));
            HttpFields fields = new HttpFields();
            while ((line = input.readLine()) != null && !line.isEmpty()) {
                int colon = line.indexOf(58);
                Assertions.assertTrue((colon > 0 ? 1 : 0) != 0);
                String name = line.substring(0, colon).trim();
                String value = line.substring(colon + 1).trim();
                fields.add(name, value);
            }
            Assertions.assertEquals((int)1, (int)fields.getValuesList("Sec-WebSocket-Protocol").size());
        }
    }
}

