/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class WebSocketServerFactoryTest {
    private int setLogLevel(Class<?> clazz, int newLevel) {
        int oldLevel = -1;
        Logger logger = Log.getLogger(clazz);
        if (logger instanceof StdErrLog) {
            StdErrLog stdErrLog = (StdErrLog)logger;
            oldLevel = stdErrLog.getLevel();
            stdErrLog.setLevel(newLevel);
        }
        return oldLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInit() {
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        QueuedThreadPool executor = new QueuedThreadPool();
        MappedByteBufferPool bufferPool = new MappedByteBufferPool();
        int wsFactoryLevel = this.setLogLevel(WebSocketServerFactory.class, 1);
        int abstractLifecycleLevel = this.setLogLevel(AbstractLifeCycle.class, 1);
        int containerLifecycleLevel = this.setLogLevel(ContainerLifeCycle.class, 1);
        try {
            WebSocketServerFactory wsFactory = new WebSocketServerFactory(policy, (Executor)executor, (ByteBufferPool)bufferPool);
            MatcherAssert.assertThat((String)"wsFactory.toString()", (Object)wsFactory.toString(), (Matcher)CoreMatchers.notNullValue());
        }
        finally {
            this.setLogLevel(WebSocketServerFactory.class, wsFactoryLevel);
            this.setLogLevel(AbstractLifeCycle.class, abstractLifecycleLevel);
            this.setLogLevel(ContainerLifeCycle.class, containerLifecycleLevel);
        }
    }
}

