/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServlet;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.test.BlockheadClient;
import org.eclipse.jetty.websocket.common.test.BlockheadClientRequest;
import org.eclipse.jetty.websocket.common.test.BlockheadConnection;
import org.eclipse.jetty.websocket.common.test.Timeouts;
import org.eclipse.jetty.websocket.server.SimpleServletServer;
import org.eclipse.jetty.websocket.server.helper.SessionServlet;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class WebSocketServerSessionTest {
    private static SimpleServletServer server;
    private static BlockheadClient client;

    @BeforeAll
    public static void startServer() throws Exception {
        server = new SimpleServletServer((HttpServlet)new SessionServlet());
        server.start();
    }

    @AfterAll
    public static void stopServer() {
        server.stop();
    }

    @BeforeAll
    public static void startClient() throws Exception {
        client = new BlockheadClient();
        client.setIdleTimeout(TimeUnit.SECONDS.toMillis(2L));
        client.start();
    }

    @AfterAll
    public static void stopClient() throws Exception {
        client.stop();
    }

    @Test
    public void testDisconnect() throws Exception {
        URI uri = server.getServerUri().resolve("/test/disconnect");
        BlockheadClientRequest request = client.newWsRequest(uri);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("harsh-disconnect"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("this shouldn't be seen by server"));
            TimeUnit.SECONDS.sleep(10L);
        }
    }

    @Test
    public void testUpgradeRequestResponse() throws Exception {
        URI uri = server.getServerUri().resolve("/test?snack=cashews&amount=handful&brand=off");
        BlockheadClientRequest request = client.newWsRequest(uri);
        CompletableFuture connFut = request.sendAsync();
        try (BlockheadConnection clientConn = (BlockheadConnection)connFut.get(2L, Timeouts.CONNECT_UNIT);){
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("getParameterMap|snack"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("getParameterMap|amount"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("getParameterMap|brand"));
            clientConn.write((WebSocketFrame)new TextFrame().setPayload("getParameterMap|cost"));
            LinkedBlockingQueue frames = clientConn.getFrameQueue();
            WebSocketFrame tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Parameter Map[snack]", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"[cashews]"));
            tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Parameter Map[amount]", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"[handful]"));
            tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Parameter Map[brand]", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"[off]"));
            tf = (WebSocketFrame)frames.poll(2L, Timeouts.POLL_EVENT_UNIT);
            MatcherAssert.assertThat((String)"Parameter Map[cost]", (Object)tf.getPayloadAsUTF8(), (Matcher)Matchers.is((Object)"<null>"));
        }
    }
}

